/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.context.ConsentManagementContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestedPromptLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeConsent
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RevokeConsent.class);
    @Nonnull
    private Function<ProfileRequestContext, Prompt> promptLookupStrategy = new DefaultRequestedPromptLookupFunction();

    public void setPromptLookupStrategy(@Nonnull Function<ProfileRequestContext, Prompt> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.promptLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"PromptLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.getOidcResponseContext().getScope().contains((Object)OIDCScopeValue.OFFLINE_ACCESS)) {
            this.log.debug("{} Pre-existing consent revoked as offline_access scope is requested", (Object)this.getLogPrefix());
            ((ConsentManagementContext)profileRequestContext.getSubcontext(ConsentManagementContext.class, true)).setRevokeConsent(true);
            return;
        }
        Prompt prompt = this.promptLookupStrategy.apply(profileRequestContext);
        if (prompt != null && prompt.contains((Object)Prompt.Type.CONSENT)) {
            this.log.debug("{} Pre-existing consent revoked as user consent is requested", (Object)this.getLogPrefix());
            ((ConsentManagementContext)profileRequestContext.getSubcontext(ConsentManagementContext.class, true)).setRevokeConsent(true);
        }
    }
}

