/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.geant.idpextension.oidc.config.OIDCCoreProtocolConfiguration;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseConsentContext;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import org.geant.idpextension.oidc.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.geant.idpextension.oidc.token.support.AccessTokenClaimsSet;
import org.geant.idpextension.oidc.token.support.AuthorizeCodeClaimsSet;
import org.geant.idpextension.oidc.token.support.RefreshTokenClaimsSet;
import org.geant.idpextension.oidc.token.support.TokenClaimsSet;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAccessTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAccessTokenToResponseContext.class);
    @Nonnull
    private final DataSealer dataSealer;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nullable
    private TokenClaimsSet tokenClaimsSet;
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nullable
    private Duration accessTokenLifetime;
    @Nullable
    private SubjectContext subjectCtx;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nullable
    private AuthenticationRequest authenticationRequest;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> consentContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseConsentContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());

    public SetAccessTokenToResponseContext(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContextt lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseConsentContext lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null) {
            this.log.error("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        ProfileConfiguration pc = rpCtx.getProfileConfig();
        if (pc == null || !(pc instanceof OIDCCoreProtocolConfiguration)) {
            this.log.error("{} No oidc profile configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.accessTokenLifetime = ((OIDCCoreProtocolConfiguration)pc).getAccessTokenLifetime(profileRequestContext);
        this.tokenClaimsSet = this.getOidcResponseContext().getTokenClaimsSet();
        if (this.tokenClaimsSet != null && !(this.tokenClaimsSet instanceof RefreshTokenClaimsSet) && !(this.tokenClaimsSet instanceof AuthorizeCodeClaimsSet)) {
            this.log.error("{} No token grant if of illegal type", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.tokenClaimsSet == null) {
            this.subjectCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, false);
            if (this.subjectCtx == null) {
                this.log.error("{} No subject context", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return false;
            }
            this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
            if (this.idGenerator == null) {
                this.log.error("{} No identifier generation strategy", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return false;
            }
            if (profileRequestContext.getInboundMessageContext() == null || profileRequestContext.getInboundMessageContext().getMessage() == null || !(profileRequestContext.getInboundMessageContext().getMessage() instanceof AuthenticationRequest)) {
                this.log.error("{} No authentication request avalailable", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
                return false;
            }
            this.authenticationRequest = (AuthenticationRequest)profileRequestContext.getInboundMessageContext().getMessage();
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AccessTokenClaimsSet claimsSet;
        Instant dateExp = Instant.now().plus(this.accessTokenLifetime);
        ClaimsSet claims = null;
        ClaimsSet claimsUI = null;
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext);
        if (tokenClaimsCtx != null) {
            claims = tokenClaimsCtx.getClaims();
            claimsUI = tokenClaimsCtx.getUserinfoClaims();
        }
        if (this.tokenClaimsSet != null) {
            claimsSet = new AccessTokenClaimsSet(this.tokenClaimsSet, this.getOidcResponseContext().getScope(), claims, claimsUI, Instant.now(), dateExp);
        } else {
            JSONArray consentable = null;
            JSONArray consented = null;
            OIDCAuthenticationResponseConsentContext consentCtx = this.consentContextLookupStrategy.apply(profileRequestContext);
            if (consentCtx != null) {
                consentable = consentCtx.getConsentableAttributes();
                consented = consentCtx.getConsentedAttributes();
            }
            claimsSet = (AccessTokenClaimsSet)new AccessTokenClaimsSet.Builder(this.idGenerator, this.authenticationRequest.getClientID(), this.issuerLookupStrategy.apply(profileRequestContext), this.subjectCtx.getPrincipalName(), this.getOidcResponseContext().getSubject(), Instant.now(), dateExp, this.getOidcResponseContext().getAuthTime(), this.getOidcResponseContext().getRedirectURI(), this.getOidcResponseContext().getScope()).setACR(this.getOidcResponseContext().getAcr()).setClaims(this.authenticationRequest.getClaims()).setConsentableClaims(consentable).setConsentedClaims(consented).setDlClaims(claims).setDlClaimsUI(claimsUI).setNonce(this.authenticationRequest.getNonce()).build();
        }
        try {
            this.getOidcResponseContext().setAccessToken(claimsSet.serialize(this.dataSealer), this.accessTokenLifetime);
            this.log.debug("{} Setting access token {} as {} to response context ", new Object[]{this.getLogPrefix(), claimsSet.serialize(), this.getOidcResponseContext().getAccessToken()});
        }
        catch (DataSealerException e) {
            this.log.error("{} Access Token generation failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
        }
    }
}

