/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import java.security.Principal;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.PreferredPrincipalContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.DefaultPrincipalDeterminationStrategy;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.authn.principal.AuthenticationContextClassReferencePrincipal;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAuthenticationContextClassReferenceToResponseContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAuthenticationContextClassReferenceToResponseContext.class);
    @Nullable
    private AuthenticationContext authCtx;
    @Nullable
    private RequestedPrincipalContext requestedPrincipalContext;
    @Nullable
    private PreferredPrincipalContext preferredPrincipalContext;
    @NonnullAfterInit
    private Function<ProfileRequestContext, AuthenticationContextClassReferencePrincipal> classRefLookupStrategy;

    public void setClassRefLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationContextClassReferencePrincipal> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.classRefLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication context class reference strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.classRefLookupStrategy == null) {
            this.classRefLookupStrategy = new DefaultPrincipalDeterminationStrategy(AuthenticationContextClassReferencePrincipal.class, (Principal)((Object)new AuthenticationContextClassReferencePrincipal("org.geant.idpextension.oidc.authn.principal.string.unspecified")));
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.authCtx = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class, false);
        if (this.authCtx == null) {
            this.log.error("{} No authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        this.requestedPrincipalContext = (RequestedPrincipalContext)this.authCtx.getSubcontext(RequestedPrincipalContext.class);
        this.preferredPrincipalContext = (PreferredPrincipalContext)this.authCtx.getSubcontext(PreferredPrincipalContext.class);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String name = null;
        if (this.requestedPrincipalContext != null && this.requestedPrincipalContext.getMatchingPrincipal() != null && this.requestedPrincipalContext.getMatchingPrincipal() instanceof AuthenticationContextClassReferencePrincipal) {
            name = this.requestedPrincipalContext.getMatchingPrincipal().getName();
            this.log.debug("{} Setting acr based on requested ctx", (Object)this.getLogPrefix());
        } else if (this.preferredPrincipalContext != null && this.authCtx.getAuthenticationResult() != null) {
            for (Principal acr : this.preferredPrincipalContext.getPreferredPrincipals()) {
                if (!this.authCtx.getAuthenticationResult().getSupportedPrincipals(AuthenticationContextClassReferencePrincipal.class).contains(acr)) continue;
                name = acr.getName();
                this.log.debug("{} Setting acr based on preferred ctx", (Object)this.getLogPrefix());
                break;
            }
        }
        if (name == null) {
            name = this.classRefLookupStrategy.apply(profileRequestContext).getName();
            this.log.debug("{} Setting acr based on performed flow", (Object)this.getLogPrefix());
        }
        if (name != null && !name.equals("org.geant.idpextension.oidc.authn.principal.string.unspecified")) {
            this.getOidcResponseContext().setAcr(name);
            this.log.debug("{} Setting acr to {}", (Object)this.getLogPrefix(), (Object)name);
        }
    }
}

