/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultAuthTimeLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAuthenticationTimeToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAuthenticationTimeToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, Instant> authTimeLookupStrategy = new DefaultAuthTimeLookupFunction();

    public void setAuthTimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Instant> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authTimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthTimeLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Instant value = this.authTimeLookupStrategy.apply(profileRequestContext);
        if (value == null) {
            this.log.error("{} No authentication instant available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        this.log.debug("{} Setting authentication time to {}", (Object)this.getLogPrefix(), (Object)value);
        this.getOidcResponseContext().setAuthTime(value);
    }
}

