/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.geant.idpextension.oidc.config.OIDCCoreProtocolConfiguration;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseConsentContext;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestCodeChallengeLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestCodeChallengeMethodLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestNonceLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationResponseAction;
import org.geant.idpextension.oidc.token.support.AuthorizeCodeClaimsSet;
import org.geant.idpextension.oidc.token.support.TokenClaimsSet;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAuthorizationCodeToResponseContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAuthorizationCodeToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private final DataSealer dataSealer;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> consentContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> codeChallengeLookupStrategy = new DefaultRequestCodeChallengeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> codeChallengeMethodLookupStrategy = new DefaultRequestCodeChallengeMethodLookupFunction();
    @Nullable
    private SubjectContext subjectCtx;
    @Nullable
    private Duration authCodeLifetime;
    @Nullable
    private String codeChallenge;

    public SetAuthorizationCodeToResponseContext(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.tokenClaimsContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        this.consentContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseConsentContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
    }

    public void setCodeChallengeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.codeChallengeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"CodeChallengeLookupStrategy lookup strategy cannot be null");
    }

    public void setCodeChallengeMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.codeChallengeMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"CodeChallengeMethodLookupStrategy lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContext lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseConsentContext lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.subjectCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, false);
        if (this.subjectCtx == null) {
            this.log.error("{} No subject context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        ProfileConfiguration pc = rpCtx.getProfileConfig();
        if (pc == null || !(pc instanceof OIDCCoreProtocolConfiguration)) {
            this.log.debug("{} No oidc profile configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.authCodeLifetime = ((OIDCCoreProtocolConfiguration)pc).getAuthorizeCodeLifetime(profileRequestContext);
        this.codeChallenge = this.codeChallengeLookupStrategy.apply(profileRequestContext);
        if (this.codeChallenge != null && !this.codeChallenge.isEmpty()) {
            String codeChallengeMethod = this.codeChallengeMethodLookupStrategy.apply(profileRequestContext);
            this.codeChallenge = (codeChallengeMethod != null ? codeChallengeMethod : "plain") + this.codeChallenge;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JSONArray consentable = null;
        JSONArray consented = null;
        OIDCAuthenticationResponseConsentContext consentCtx = this.consentContextLookupStrategy.apply(profileRequestContext);
        if (consentCtx != null) {
            consentable = consentCtx.getConsentableAttributes();
            consented = consentCtx.getConsentedAttributes();
        }
        ClaimsSet claims = null;
        ClaimsSet claimsID = null;
        ClaimsSet claimsUI = null;
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext);
        if (tokenClaimsCtx != null) {
            claims = tokenClaimsCtx.getClaims();
            claimsID = tokenClaimsCtx.getIdtokenClaims();
            claimsUI = tokenClaimsCtx.getUserinfoClaims();
        }
        Instant dateExp = Instant.now().plus(this.authCodeLifetime);
        AuthorizeCodeClaimsSet claimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder(this.idGenerator, this.getAuthenticationRequest().getClientID(), this.issuerLookupStrategy.apply(profileRequestContext), this.subjectCtx.getPrincipalName(), this.getOidcResponseContext().getSubject(), Instant.now(), dateExp, this.getOidcResponseContext().getAuthTime(), this.getOidcResponseContext().getRedirectURI(), this.getOidcResponseContext().getScope()).setACR(this.getOidcResponseContext().getAcr()).setNonce((Nonce)new DefaultRequestNonceLookupFunction().apply(profileRequestContext)).setClaims(this.getOidcResponseContext().getRequestedClaims()).setDlClaims(claims).setDlClaimsID(claimsID).setDlClaimsUI(claimsUI).setConsentableClaims(consentable).setConsentedClaims(consented).setCodeChallenge(this.codeChallenge).build();
        this.getOidcResponseContext().setTokenClaimsSet((TokenClaimsSet)claimsSet);
        try {
            this.getOidcResponseContext().setAuthorizationCode(claimsSet.serialize(this.dataSealer));
            this.log.debug("{} Setting authz code {} as {} to response context ", new Object[]{this.getLogPrefix(), claimsSet.serialize(), this.getOidcResponseContext().getAuthorizationCode()});
        }
        catch (DataSealerException e) {
            this.log.error("{} Authorization Code generation failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
        }
    }
}

