/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minidev.json.JSONArray;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseConsentContext;
import org.geant.idpextension.oidc.profile.context.navigate.TokenRequestConsentableAttributesLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.TokenRequestConsentedAttributesLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetConsentFromTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetConsentFromTokenToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, JSONArray> consentedAttributesLookupStrategy = new TokenRequestConsentedAttributesLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, JSONArray> consentableAttributesLookupStrategy = new TokenRequestConsentableAttributesLookupFunction();

    public void setConsentedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, JSONArray> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ConsentedAttributesLookupStrategy lookup strategy cannot be null");
    }

    public void setConsentableAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, JSONArray> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentableAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ConsentableAttributesLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JSONArray consentedAttributes = this.consentedAttributesLookupStrategy.apply(profileRequestContext);
        JSONArray consentableAttributes = this.consentableAttributesLookupStrategy.apply(profileRequestContext);
        if (consentedAttributes != null || consentableAttributes != null) {
            OIDCAuthenticationResponseConsentContext consentClaimsCtx = (OIDCAuthenticationResponseConsentContext)this.getOidcResponseContext().getSubcontext(OIDCAuthenticationResponseConsentContext.class, true);
            consentClaimsCtx.getConsentableAttributes().addAll((Collection)consentableAttributes);
            consentClaimsCtx.getConsentedAttributes().addAll((Collection)consentedAttributes);
        }
    }
}

