/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.AttributeReleaseContext;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCAuthenticationResponseConsentContext;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetConsentToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetConsentToResponseContext.class);
    @Nullable
    private ConsentContext consentContext;
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class, false);
    @Nullable
    private AttributeReleaseContext attributeReleaseContext;
    @Nonnull
    private Function<ProfileRequestContext, AttributeReleaseContext> attributeReleaseContextLookupStrategy = new ChildContextLookup(AttributeReleaseContext.class, false);

    SetConsentToResponseContext() {
    }

    public void setConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    public void setAttributeReleaseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeReleaseContext> strategy) {
        this.attributeReleaseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Attribute release context lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.consentContext = this.consentContextLookupStrategy.apply(profileRequestContext);
        if (this.consentContext == null) {
            this.log.debug("{} Unable to locate consent context within profile request context, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.attributeReleaseContext = this.attributeReleaseContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeReleaseContext == null) {
            this.log.debug("{} Unable to locate attribute release context within profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseConsentContext oidcConsentCtx = (OIDCAuthenticationResponseConsentContext)this.getOidcResponseContext().getSubcontext(OIDCAuthenticationResponseConsentContext.class, true);
        Map consents = this.consentContext.getCurrentConsents().isEmpty() ? this.consentContext.getPreviousConsents() : this.consentContext.getCurrentConsents();
        for (String key : consents.keySet()) {
            if (consents.get(key) == null || !((Consent)consents.get(key)).isApproved()) continue;
            oidcConsentCtx.getConsentedAttributes().add((Object)key);
        }
        if (this.attributeReleaseContext.getConsentableAttributes() != null) {
            oidcConsentCtx.getConsentableAttributes().addAll(this.attributeReleaseContext.getConsentableAttributes().keySet());
        }
        this.log.debug("{} Set to response context consented attributes {} and consentable attributes {}", new Object[]{this.getLogPrefix(), oidcConsentCtx.getConsentedAttributes().toJSONString(), oidcConsentCtx.getConsentableAttributes().toJSONString()});
    }
}

