/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestedClaimsLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetRequestedClaimsToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetRequestedClaimsToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, ClaimsRequest> requestedClaimsLookupStrategy = new DefaultRequestedClaimsLookupFunction();
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setRequestedClaimsLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestedClaimsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RequestedClaimsLookupStrategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClaimsRequest cr = this.requestedClaimsLookupStrategy.apply(profileRequestContext);
        this.getOidcResponseContext().setRequestedClaims(cr);
        if (cr == null) {
            this.getOidcResponseContext().setMappedIdTokenRequestedClaims(null);
            this.getOidcResponseContext().setMappedUserinfoRequestedClaims(null);
            return;
        }
        ServiceableComponent component = null;
        try {
            Collection transcodingRules;
            JSONObject wrapper;
            component = this.transcoderRegistry.getServiceableComponent();
            if (component == null) {
                this.log.error("Attribute transoding service unavailable");
                ActionSupport.buildEvent((Object)profileRequestContext, (String)"MessageProcessingError");
                return;
            }
            HashMultimap results = HashMultimap.create();
            for (ClaimsRequest.Entry entry : cr.getIDTokenClaims()) {
                wrapper = new JSONObject();
                wrapper.put((Object)entry.getClaimName(), (Object)entry);
                transcodingRules = ((AttributeTranscoderRegistry)component.getComponent()).getTranscodingRules((Object)wrapper);
                this.decodeAttribute(profileRequestContext, transcodingRules, wrapper, (Multimap<String, IdPAttribute>)results);
            }
            this.getOidcResponseContext().setMappedIdTokenRequestedClaims(results.isEmpty() ? null : new AttributesMapContainer((Multimap)results));
            results = HashMultimap.create();
            for (ClaimsRequest.Entry entry : cr.getUserInfoClaims()) {
                wrapper = new JSONObject();
                wrapper.put((Object)entry.getClaimName(), (Object)entry);
                transcodingRules = ((AttributeTranscoderRegistry)component.getComponent()).getTranscodingRules((Object)wrapper);
                this.decodeAttribute(profileRequestContext, transcodingRules, wrapper, (Multimap<String, IdPAttribute>)results);
            }
            this.getOidcResponseContext().setMappedUserinfoRequestedClaims(results.isEmpty() ? null : new AttributesMapContainer((Multimap)results));
        }
        finally {
            if (component != null) {
                component.unpinComponent();
            }
        }
    }

    private void decodeAttribute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NonnullElements Collection<TranscodingRule> rules, @Nonnull JSONObject input, @Nonnull @NonnullElements @Live Multimap<String, IdPAttribute> results) {
        for (TranscodingRule rule : rules) {
            AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
            try {
                IdPAttribute decodedAttribute = transcoder.decode(profileRequestContext, (Object)input, rule);
                if (decodedAttribute == null) continue;
                results.put((Object)decodedAttribute.getId(), (Object)decodedAttribute);
            }
            catch (AttributeDecodingException e) {
                this.log.warn("{} Failed to decode requested claim '{}'", (Object)this.getLogPrefix(), input.keySet().iterator().next());
            }
        }
    }
}

