/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.SubjectType;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.context.navigate.SectorIdentifierLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationRequestAction;
import org.geant.idpextension.oidc.profile.logic.DefaultSubjectTypeStrategy;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetSectorIdentifierForAttributeResolution
extends AbstractOIDCAuthenticationRequestAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SetSectorIdentifierForAttributeResolution.class);
    @Nonnull
    private Function<ProfileRequestContext, String> sectorIdentifierLookupStrategy = new SectorIdentifierLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, SubjectType> subjectTypeLookupStrategy = new DefaultSubjectTypeStrategy();

    public void setSectorIdentifierLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sectorIdentifierLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SectorIdentifierLookupStrategy lookup strategy cannot be null");
    }

    public void setSubjectTypeLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectType> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.subjectTypeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectTypeLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (SubjectType.PUBLIC.equals((Object)this.subjectTypeLookupStrategy.apply(profileRequestContext))) {
            ((AttributeResolutionContext)profileRequestContext.getSubcontext(AttributeResolutionContext.class, true)).setAttributeRecipientGroupID("public");
            this.log.debug("{} Attribute recipient group id set to value public for generating subject of type public", (Object)this.getLogPrefix());
            return;
        }
        String sectorIdentifier = this.sectorIdentifierLookupStrategy.apply(profileRequestContext);
        if (sectorIdentifier == null) {
            this.log.error("{} No sector identifier, pairwise subject cannot be generated", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MissingRedirectionURIs");
            return;
        }
        ((AttributeResolutionContext)profileRequestContext.getSubcontext(AttributeResolutionContext.class, true)).setAttributeRecipientGroupID(sectorIdentifier);
        this.log.debug("{} Attribute recipient group id set to sector identifier value {} for generating subject of type pairwise", (Object)this.getLogPrefix(), (Object)sectorIdentifier);
    }
}

