/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.impl.AbstractSignJWTAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignIDToken
extends AbstractSignJWTAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SignIDToken.class);
    private JWTClaimsSet idTokenClaims;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getOidcResponseContext().getIDToken() == null) {
            this.log.error("{} No id token available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        try {
            this.idTokenClaims = this.getOidcResponseContext().getIDToken().toJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.error("{} id token parsing failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Override
    protected JWTClaimsSet getClaimsSetToSign() {
        return this.idTokenClaims;
    }

    @Override
    protected void setSignedJWT(SignedJWT jwt) {
        this.getOidcResponseContext().setProcessedToken((JWT)jwt);
    }
}

