/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.security.interfaces.ECPrivateKey;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.navigate.OIDCClientRegistrationResponseMetadataLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.MetadataStatementsLookupFunction;
import org.geant.idpextension.oidc.security.impl.CredentialConversionUtil;
import org.geant.security.jwk.JWKCredential;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignRegistrationResponse
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SignRegistrationResponse.class);
    private Credential credential;
    private OIDCClientInformationResponse response;
    private String issuer;
    @Nonnull
    private Function<ProfileRequestContext, Map<String, String>> metadataStatementsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class);
    @Nullable
    private SignatureSigningParameters signatureSigningParameters;

    public SignRegistrationResponse() {
        this.metadataStatementsLookupStrategy = new MetadataStatementsLookupFunction();
        ((MetadataStatementsLookupFunction)this.metadataStatementsLookupStrategy).setMetadataLookupStrategy((Function)new OIDCClientRegistrationResponseMetadataLookupFunction());
    }

    public void setIssuer(String iss) {
        this.issuer = Constraint.isNotEmpty((String)iss, (String)"The issuer cannot be empty!");
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    public void setMetadataStatementsLookupStrategy(@Nonnull Function<ProfileRequestContext, Map<String, String>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataStatementsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata statements lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        SecurityParametersContext secParamCtx = this.securityParametersLookupStrategy.apply(profileRequestContext);
        if (secParamCtx == null) {
            this.log.debug("{} Will not sign id token because no security parameters context is available", (Object)this.getLogPrefix());
            return false;
        }
        this.signatureSigningParameters = secParamCtx.getSignatureSigningParameters();
        if (this.signatureSigningParameters == null || this.signatureSigningParameters.getSigningCredential() == null) {
            this.log.debug("{} Will not sign id token because no signature signing credentials available", (Object)this.getLogPrefix());
            return false;
        }
        this.credential = this.signatureSigningParameters.getSigningCredential();
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.error("{} Unable to locate outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        Object message = profileRequestContext.getOutboundMessageContext().getMessage();
        if (message == null || !(message instanceof OIDCClientInformationResponse)) {
            this.log.error("{} Unable to locate outbound message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.response = (OIDCClientInformationResponse)message;
        return true;
    }

    private JWSSigner getSigner(Algorithm jwsAlgorithm) throws JOSEException {
        if (JWSAlgorithm.Family.EC.contains((Object)jwsAlgorithm)) {
            return new ECDSASigner((ECPrivateKey)this.credential.getPrivateKey());
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm)) {
            return new RSASSASigner(this.credential.getPrivateKey());
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm)) {
            return new MACSigner(this.credential.getSecretKey());
        }
        throw new JOSEException("Unsupported algorithm " + jwsAlgorithm.getName());
    }

    private JWSAlgorithm resolveAlgorithm() {
        JWSAlgorithm algorithm = new JWSAlgorithm(this.signatureSigningParameters.getSignatureAlgorithm());
        if (this.credential instanceof JWKCredential && !algorithm.equals((Object)((JWKCredential)this.credential).getAlgorithm())) {
            this.log.warn("{} Signature signing algorithm {} differs from JWK algorithm {}", new Object[]{this.getLogPrefix(), algorithm.getName(), ((JWKCredential)this.credential).getAlgorithm()});
        }
        this.log.debug("{} Algorithm resolved {}", (Object)this.getLogPrefix(), (Object)algorithm.getName());
        return algorithm;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClientMetadata responseMetadata = this.response.getOIDCClientInformation().getOIDCMetadata();
        Map<String, String> statements = this.metadataStatementsLookupStrategy.apply(profileRequestContext);
        if (statements == null || statements.isEmpty()) {
            this.log.debug("{} No existing metadata_statements, nothing to be done", (Object)this.getLogPrefix());
            return;
        }
        String federationId = statements.keySet().iterator().next();
        SignedJWT jwt = null;
        JWSAlgorithm jwsAlgorithm = this.resolveAlgorithm();
        String kid = CredentialConversionUtil.resolveKid(this.credential);
        try {
            JWSSigner signer = this.getSigner((Algorithm)jwsAlgorithm);
            responseMetadata.setCustomField("kid", (Object)kid);
            responseMetadata.setCustomField("iss", (Object)this.issuer);
            responseMetadata.setCustomField("exp", (Object)Instant.now().plus(Duration.ofHours(1L)).getEpochSecond());
            jwt = new SignedJWT(new JWSHeader.Builder(new JWSAlgorithm(jwsAlgorithm.getName())).keyID(kid).build(), JWTClaimsSet.parse((JSONObject)this.response.getOIDCClientInformation().toJSONObject()));
            jwt.sign(signer);
            JSONObject newStatements = new JSONObject();
            newStatements.put((Object)federationId, (Object)jwt.serialize());
            responseMetadata.setCustomField("metadata_statements", (Object)newStatements);
        }
        catch (ParseException e) {
            this.log.error("{} Error parsing claimset: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        catch (JOSEException e) {
            this.log.error("{} Error signing id token: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToSign");
            return;
        }
        this.log.debug("{} signed id token stored to context", (Object)this.getLogPrefix());
    }
}

