/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultUserInfoSigningAlgLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractSignJWTAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUserInfoResponse
extends AbstractSignJWTAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SignUserInfoResponse.class);
    @Nullable
    private JWTClaimsSet userInfoClaims;
    @Nonnull
    private Function<ProfileRequestContext, JWSAlgorithm> userInfoSigAlgStrategy = new DefaultUserInfoSigningAlgLookupFunction();

    public void setUserInfoSigningAlgLookupStrategy(@Nonnull Function<ProfileRequestContext, JWSAlgorithm> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.userInfoSigAlgStrategy = (Function)Constraint.isNotNull(strategy, (String)"User Info Signing Algorithm lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext) || this.userInfoSigAlgStrategy.apply(profileRequestContext) == null) {
            return false;
        }
        if (this.getOidcResponseContext().getUserInfo() == null) {
            this.log.error("{} No userinfo available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        try {
            this.userInfoClaims = this.getOidcResponseContext().getUserInfo().toJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.error("{} userinfo parsing failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    @Override
    protected JWTClaimsSet getClaimsSetToSign() {
        return this.userInfoClaims;
    }

    @Override
    protected void setSignedJWT(SignedJWT jwt) {
        this.getOidcResponseContext().setProcessedToken((JWT)jwt);
    }
}

