/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCClientRegistrationResponseContext;
import org.geant.idpextension.oidc.metadata.resolver.ClientInformationManager;
import org.geant.idpextension.oidc.metadata.resolver.ClientInformationManagerException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreClientInformation
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoreClientInformation.class);
    @Nullable
    private ClientInformationManager clientInformationManager;
    @Nullable
    private Function<ProfileRequestContext, Duration> registrationValidityPeriodStrategy;
    @Nullable
    @NonNegative
    private Duration defaultRegistrationValidityPeriod;
    @Nullable
    private OIDCClientInformationResponse response;
    @Nonnull
    private Function<MessageContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy = new ChildContextLookup(OIDCClientRegistrationResponseContext.class);

    public StoreClientInformation() {
        this.defaultRegistrationValidityPeriod = Duration.ofHours(24L);
    }

    public void setRegistrationValidityPeriodStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.registrationValidityPeriodStrategy = strategy;
    }

    public void setDefaultRegistrationValidityPeriod(@Nonnull @NonNegative Duration lifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isFalse((lifetime == null || lifetime.isNegative() ? 1 : 0) != 0, (String)"Default registration validity period must be greater than or equal to 0");
        this.defaultRegistrationValidityPeriod = lifetime;
    }

    @NonnullAfterInit
    public ClientInformationManager getClientInformationManager() {
        return this.clientInformationManager;
    }

    public void setClientInformationManager(@Nonnull ClientInformationManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.clientInformationManager = (ClientInformationManager)Constraint.isNotNull((Object)manager, (String)"The client information manager cannot be null!");
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<MessageContext, OIDCClientRegistrationResponseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.clientInformationManager == null) {
            throw new ComponentInitializationException("ClientInformationManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.error("{} Unable to locate outbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        Object message = profileRequestContext.getOutboundMessageContext().getMessage();
        if (message == null || !(message instanceof OIDCClientInformationResponse)) {
            this.log.error("{} Unable to locate outbound message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.response = (OIDCClientInformationResponse)message;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClientInformation clientInformation = this.response.getOIDCClientInformation();
        Duration lifetime = this.registrationValidityPeriodStrategy != null ? this.registrationValidityPeriodStrategy.apply(profileRequestContext) : null;
        try {
            if (lifetime != null && lifetime.isZero()) {
                this.log.debug("{} Registration won't expire, lifetime set to 0", (Object)this.getLogPrefix());
                this.clientInformationManager.storeClientInformation(clientInformation, null);
            } else {
                if (lifetime == null) {
                    this.log.debug("{} No registration validity period supplied, using default", (Object)this.getLogPrefix());
                }
                Instant expiration = Instant.now().plus(lifetime != null ? lifetime : this.defaultRegistrationValidityPeriod);
                this.log.debug("{} Registration will expire on {}", (Object)this.getLogPrefix(), (Object)expiration);
                this.clientInformationManager.storeClientInformation(clientInformation, expiration);
            }
        }
        catch (ClientInformationManagerException e) {
            this.log.error("{} Could not store the client information", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return;
        }
        this.log.info("{} Client information successfully stored for {}", (Object)this.getLogPrefix(), (Object)clientInformation.getID().getValue());
    }
}

