/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCUserInfoValidationResponseAction;
import org.geant.idpextension.oidc.storage.RevocationCache;
import org.geant.idpextension.oidc.storage.RevocationCacheContexts;
import org.geant.idpextension.oidc.token.support.AccessTokenClaimsSet;
import org.geant.idpextension.oidc.token.support.TokenClaimsSet;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAccessToken
extends AbstractOIDCUserInfoValidationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateAccessToken.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private RevocationCache revocationCache;

    public ValidateAccessToken(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AccessTokenClaimsSet accessTokenClaimsSet;
        try {
            accessTokenClaimsSet = AccessTokenClaimsSet.parse((String)this.getUserInfoRequest().getAccessToken().getValue(), (DataSealer)this.dataSealer);
            this.log.debug("{} access token unwrapped {}", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.serialize());
        }
        catch (ParseException | DataSealerException e) {
            this.log.error("{} Obtaining access token failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (accessTokenClaimsSet.isExpired()) {
            this.log.error("{} access token exp is in the past {}", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.getExp());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, accessTokenClaimsSet.getID())) {
            this.log.error("{} authorize code {} and all derived tokens have been revoked", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.getID());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        this.log.debug("{} access token {} validated", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.getID());
        this.getOidcResponseContext().setTokenClaimsSet((TokenClaimsSet)accessTokenClaimsSet);
    }
}

