/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AbstractOptionallyAuthenticatedRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.JWTAuthentication;
import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.config.navigate.TokenEndpointAuthMethodLookupFunction;
import org.geant.idpextension.oidc.messaging.context.OIDCMetadataContext;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCRequestAction;
import org.geant.idpextension.oidc.security.impl.JWTSignatureValidationUtil;
import org.geant.idpextension.oidc.security.impl.OIDCSignatureValidationParameters;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.storage.ReplayCache;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateEndpointAuthentication
extends AbstractOIDCRequestAction<AbstractOptionallyAuthenticatedRequest> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateEndpointAuthentication.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
    @Nullable
    private Function<ProfileRequestContext, List<ClientAuthenticationMethod>> tokenEndpointAuthMethodsLookupStrategy = new TokenEndpointAuthMethodLookupFunction();
    @NonnullAfterInit
    private ReplayCache replayCache;
    @Nullable
    private OIDCMetadataContext oidcMetadataContext;
    @Nullable
    private OIDCSignatureValidationParameters signatureValidationParameters;
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class);

    public void setOidcMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadataContext lookup strategy cannot be null");
    }

    public void setTokenEndpointAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<ClientAuthenticationMethod>> strategy) {
        this.tokenEndpointAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy to obtain enabled token endpoint authentication methods cannot be null");
    }

    public void setReplayCache(@Nonnull ReplayCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.replayCache = (ReplayCache)Constraint.isNotNull((Object)cache, (String)"ReplayCache cannot be null");
    }

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.replayCache == null) {
            throw new ComponentInitializationException("ReplayCache cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oidcMetadataContext = this.oidcMetadataContextLookupStrategy.apply(profileRequestContext);
        if (this.oidcMetadataContext == null) {
            this.log.error("{} OICDMetadataContext is null", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AbstractOptionallyAuthenticatedRequest request = (AbstractOptionallyAuthenticatedRequest)this.getRequest();
        OIDCClientInformation clientInformation = this.oidcMetadataContext.getClientInformation();
        OIDCClientMetadata clientMetadata = clientInformation.getOIDCMetadata();
        ClientAuthenticationMethod clientAuthMethod = clientMetadata.getTokenEndpointAuthMethod() != null ? clientMetadata.getTokenEndpointAuthMethod() : ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
        ClientAuthentication clientAuth = request.getClientAuthentication();
        List<ClientAuthenticationMethod> enabledMethods = this.tokenEndpointAuthMethodsLookupStrategy.apply(profileRequestContext);
        if (this.enabledAndEquals(enabledMethods, clientAuthMethod, ClientAuthenticationMethod.NONE)) {
            this.log.debug("{} None authentication is requested and enabled, nothing to do", (Object)this.getLogPrefix());
            return;
        }
        if (this.enabledAndEquals(enabledMethods, clientAuthMethod, ClientAuthenticationMethod.CLIENT_SECRET_BASIC)) {
            if (clientAuth instanceof ClientSecretBasic) {
                if (this.validateSecret((PlainClientSecret)((ClientSecretBasic)clientAuth), clientInformation)) {
                    return;
                }
            } else {
                this.log.warn("{} Unrecognized client authentication {} for client_secret_basic", (Object)this.getLogPrefix(), (Object)request.getClientAuthentication());
            }
        } else if (this.enabledAndEquals(enabledMethods, clientAuthMethod, ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
            if (clientAuth instanceof ClientSecretPost) {
                if (this.validateSecret((PlainClientSecret)((ClientSecretPost)clientAuth), clientInformation)) {
                    return;
                }
            } else {
                this.log.warn("{} Unrecognized client authentication {} for client_secret_post", (Object)this.getLogPrefix(), (Object)request.getClientAuthentication());
            }
        } else if (this.enabledAndEquals(enabledMethods, clientAuthMethod, ClientAuthenticationMethod.CLIENT_SECRET_JWT) || this.enabledAndEquals(enabledMethods, clientAuthMethod, ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            if (clientAuth instanceof JWTAuthentication) {
                SignedJWT jwt = ((JWTAuthentication)clientAuth).getClientAssertion();
                String errorEventId = JWTSignatureValidationUtil.validateSignature(this.securityParametersLookupStrategy.apply(profileRequestContext), jwt, "AccessDenied");
                if (errorEventId != null) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)errorEventId);
                }
                return;
            }
        } else {
            this.log.warn("{} Unsupported client authentication method {}", (Object)this.getLogPrefix(), (Object)clientAuth.getMethod());
        }
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
    }

    protected boolean enabledAndEquals(List<ClientAuthenticationMethod> enabledMethods, ClientAuthenticationMethod requestedMethod, ClientAuthenticationMethod desiredMethod) {
        if (requestedMethod.equals((Object)desiredMethod)) {
            if (enabledMethods == null || enabledMethods.isEmpty()) {
                this.log.warn("{} List of enabled methods is empty, all methods are disabled", (Object)this.getLogPrefix());
                return false;
            }
            if (!enabledMethods.contains(requestedMethod)) {
                this.log.warn("{} The requested method {} is not enabled", (Object)this.getLogPrefix(), (Object)requestedMethod);
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateSecret(PlainClientSecret secret, OIDCClientInformation clientInformation) {
        Secret clientSecret = secret.getClientSecret();
        if (clientSecret == null) {
            this.log.warn("{} The client secret was null and cannot be validated", (Object)this.getLogPrefix());
            return false;
        }
        if (clientSecret.equals((Object)clientInformation.getSecret())) {
            this.log.debug("{} The client secret successfully verified", (Object)this.getLogPrefix());
            return true;
        }
        this.log.warn("{} The client secret validation failed", (Object)this.getLogPrefix());
        return false;
    }
}

