/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCTokenResponseAction;
import org.geant.idpextension.oidc.storage.RevocationCache;
import org.geant.idpextension.oidc.storage.RevocationCacheContexts;
import org.geant.idpextension.oidc.token.support.AuthorizeCodeClaimsSet;
import org.geant.idpextension.oidc.token.support.RefreshTokenClaimsSet;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.ReplayCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateGrant
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateGrant.class);
    @Nonnull
    private final DataSealer dataSealer;
    @NonnullAfterInit
    private ReplayCache replayCache;
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nullable
    private RelyingPartyContext rpCtx;

    public ValidateGrant(@Nonnull @ParameterName(name="sealer") DataSealer sealer) {
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setReplayCache(@Nonnull ReplayCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.replayCache = (ReplayCache)Constraint.isNotNull((Object)cache, (String)"ReplayCache cannot be null");
    }

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.replayCache == null || this.revocationCache == null) {
            throw new ComponentInitializationException("ReplayCache and RevocationCache cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.rpCtx == null) {
            this.log.error("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RefreshTokenGrant refreshTokentokenGrant;
        AuthorizationGrant grant = this.getTokenRequest().getAuthorizationGrant();
        RefreshTokenClaimsSet tokenClaimsSet = null;
        if (grant.getType().equals((Object)GrantType.AUTHORIZATION_CODE)) {
            AuthorizationCodeGrant codeGrant = (AuthorizationCodeGrant)grant;
            if (codeGrant.getAuthorizationCode() != null && codeGrant.getAuthorizationCode().getValue() != null) {
                try {
                    AuthorizeCodeClaimsSet authzCodeClaimsSet = AuthorizeCodeClaimsSet.parse((String)codeGrant.getAuthorizationCode().getValue(), (DataSealer)this.dataSealer);
                    this.log.debug("{} authz code unwrapped {}", (Object)this.getLogPrefix(), (Object)authzCodeClaimsSet.serialize());
                    if (!this.replayCache.check(((Object)((Object)this)).getClass().getName(), authzCodeClaimsSet.getID(), authzCodeClaimsSet.getExp())) {
                        this.log.error("{} Replay detected of authz code {}", (Object)this.getLogPrefix(), (Object)authzCodeClaimsSet.getID());
                        if (!this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, authzCodeClaimsSet.getID())) {
                            this.log.error("{} Fatal error! Unable to set entry to revocation cache", (Object)this.getLogPrefix());
                        }
                        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                        return;
                    }
                    tokenClaimsSet = authzCodeClaimsSet;
                }
                catch (ParseException | DataSealerException e) {
                    this.log.error("{} Obtaining authz code failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
            }
        } else if (grant.getType().equals((Object)GrantType.REFRESH_TOKEN) && (refreshTokentokenGrant = (RefreshTokenGrant)grant).getRefreshToken() != null && refreshTokentokenGrant.getRefreshToken().getValue() != null) {
            try {
                RefreshTokenClaimsSet refreshTokenClaimsSet = RefreshTokenClaimsSet.parse((String)refreshTokentokenGrant.getRefreshToken().getValue(), (DataSealer)this.dataSealer);
                if (this.revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, refreshTokenClaimsSet.getID())) {
                    this.log.error("{} authorize code {} and all derived tokens have been revoked", (Object)this.getLogPrefix(), (Object)refreshTokenClaimsSet.getID());
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                    return;
                }
                tokenClaimsSet = refreshTokenClaimsSet;
            }
            catch (ParseException | DataSealerException e) {
                this.log.error("{} Obtaining refresh token failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                return;
            }
        }
        if (tokenClaimsSet == null) {
            this.log.error("{} Grant type not supported", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (tokenClaimsSet.isExpired()) {
            this.log.error("{} token exp is in the past {}", (Object)this.getLogPrefix(), (Object)tokenClaimsSet.getExp());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        if (!tokenClaimsSet.getClientID().getValue().equals(this.rpCtx.getRelyingPartyId())) {
            this.log.error("{} token issued for client {}, expected value was {}", new Object[]{this.getLogPrefix(), tokenClaimsSet.getClientID().getValue(), this.rpCtx.getRelyingPartyId()});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        this.getOidcResponseContext().setTokenClaimsSet(tokenClaimsSet);
    }
}

