/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import java.util.Set;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCTokenResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateGrantType
extends AbstractOIDCTokenResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateGrantType.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Set registeredTypes = this.getMetadataContext().getClientInformation().getMetadata().getGrantTypes();
        AuthorizationGrant grant = this.getTokenRequest().getAuthorizationGrant();
        if (registeredTypes == null || registeredTypes.isEmpty() || !registeredTypes.contains(grant.getType())) {
            this.log.error("{} The grant type {} is not registered for this RP", (Object)this.getLogPrefix(), (Object)grant.getType().getValue());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrantType");
        }
    }
}

