/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jose.util.Base64URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.config.OIDCCoreProtocolConfiguration;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestCodeVerifierLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCResponseAction;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatePKCE
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidatePKCE.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> codeVerifierLookupStrategy = new DefaultRequestCodeVerifierLookupFunction();
    private boolean forcePKCE;
    private boolean plainPKCE;
    @Nullable
    private String codeChallenge;
    @Nullable
    private String codeVerifier;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setCodeVerifierLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.codeVerifierLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"CodeVerifier lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getOidcResponseContext().getTokenClaimsSet() == null) {
            this.log.error("{} No validated token claims set available, missing a prior action", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (!"ac".equals(this.getOidcResponseContext().getTokenClaimsSet().getType())) {
            this.log.debug("{} No authorization code presented, PKCE not applied, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null) {
            this.log.error("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        ProfileConfiguration pc = rpCtx.getProfileConfig();
        if (pc == null || !(pc instanceof OIDCCoreProtocolConfiguration)) {
            this.log.error("{} No oidc profile configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.forcePKCE = ((OIDCCoreProtocolConfiguration)pc).isForcePKCE(profileRequestContext);
        this.plainPKCE = ((OIDCCoreProtocolConfiguration)pc).isAllowPKCEPlain(profileRequestContext);
        this.codeChallenge = this.getOidcResponseContext().getTokenClaimsSet().getCodeChallenge();
        if ((this.codeChallenge == null || this.codeChallenge.isEmpty()) && !this.forcePKCE) {
            this.log.debug("{} No PKCE code challenge in request, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.codeVerifier = this.codeVerifierLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.codeChallenge == null || this.codeChallenge.isEmpty()) {
            this.log.error("{} No PKCE code challenge presented in authentication request even though required to access token endpoint", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        if (this.codeVerifier == null || this.codeVerifier.isEmpty()) {
            this.log.error("{} No PKCE code verifier for code challenge presented in token request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        if (this.codeChallenge.startsWith("plain")) {
            if (!this.plainPKCE) {
                this.log.error("{} Plain PKCE code challenge method not allowed", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
                return;
            }
            String codeChallengeValue = this.codeChallenge.substring("plain".length());
            if (!this.codeVerifier.equals(codeChallengeValue)) {
                this.log.error("{} PKCE code challenge {} not matching code verifier {}", new Object[]{this.getLogPrefix(), codeChallengeValue, this.codeVerifier});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageAuthenticationError");
                return;
            }
        } else if (this.codeChallenge.startsWith("S256")) {
            String codeChallengeValue = this.codeChallenge.substring("S256".length());
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error("{} PKCE S256 code challenge verification requires SHA-256", new Object[]{this.getLogPrefix(), codeChallengeValue, this.codeVerifier});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageAuthenticationError");
                return;
            }
            byte[] hash = md.digest(this.codeVerifier.getBytes(Charset.forName("utf-8")));
            String codeChallengeComparisonValue = Base64URL.encode((byte[])hash).toString();
            if (!codeChallengeComparisonValue.equals(codeChallengeValue)) {
                this.log.error("{} PKCE code challenge {} not matching code verifier {}({})", new Object[]{this.getLogPrefix(), codeChallengeValue, this.codeVerifier, codeChallengeComparisonValue});
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageAuthenticationError");
                return;
            }
        } else {
            this.log.error("{} Unknown code challenge method", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
    }
}

