/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationResponseAction;
import org.geant.idpextension.oidc.security.impl.JWTSignatureValidationUtil;
import org.geant.idpextension.oidc.security.impl.OIDCSignatureValidationParameters;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateRequestObject
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateRequestObject.class);
    @Nullable
    private OIDCSignatureValidationParameters signatureValidationParameters;
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class);
    @Nullable
    private JWT requestObject;

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.requestObject = this.getOidcResponseContext().getRequestObject();
        if (this.requestObject == null) {
            this.log.debug("{} No request object, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SecurityParametersContext secParamCtx;
        String errorEventId;
        if (this.requestObject instanceof PlainJWT && this.getMetadataContext().getClientInformation().getOIDCMetadata().getRequestObjectJWSAlg() != null && !"none".equals(this.getMetadataContext().getClientInformation().getOIDCMetadata().getRequestObjectJWSAlg().getName())) {
            this.log.error("{} Request object is not signed evethough registered alg is {}", (Object)this.getLogPrefix(), (Object)this.getMetadataContext().getClientInformation().getOIDCMetadata().getRequestObjectJWSAlg().getName());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
        if (!(this.requestObject instanceof PlainJWT) && (errorEventId = JWTSignatureValidationUtil.validateSignature(secParamCtx = this.securityParametersLookupStrategy.apply(profileRequestContext), (SignedJWT)this.requestObject, "InvalidRequestObject")) != null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)errorEventId);
            return;
        }
        try {
            if (this.requestObject.getJWTClaimsSet().getClaims().containsKey("client_id") && !this.getAuthenticationRequest().getClientID().equals((Object)new ClientID((String)this.requestObject.getJWTClaimsSet().getClaim("client_id")))) {
                this.log.error("{} client_id in request object not matching client_id request parameter", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
            if (this.requestObject.getJWTClaimsSet().getClaims().containsKey("response_type") && !this.getAuthenticationRequest().getResponseType().equals((Object)new ResponseType(((String)this.requestObject.getJWTClaimsSet().getClaim("response_type")).split(" ")))) {
                this.log.error("{} response_type in request object not matching response_type request parameter", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
        }
        catch (ParseException e) {
            this.log.error("{} Unable to parse request object {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
    }
}

