/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import java.util.Set;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestResponseTypeLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateResponseType
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateResponseType.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Set registeredTypes = this.getMetadataContext().getClientInformation().getMetadata().getResponseTypes();
        ResponseType requestedType = (ResponseType)new DefaultRequestResponseTypeLookupFunction().apply(profileRequestContext);
        if (registeredTypes == null || registeredTypes.isEmpty() || !registeredTypes.contains(requestedType)) {
            this.log.warn("{} The response type {} is not registered for this RP", (Object)this.getLogPrefix(), (Object)requestedType);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidResponseType");
        }
    }
}

