/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestResponseTypeLookupFunction;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultRequestedScopeLookupFunction;
import org.geant.idpextension.oidc.profile.impl.AbstractOIDCAuthenticationResponseAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateScope
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateScope.class);
    @Nonnull
    private Function<ProfileRequestContext, Scope> scopeLookupStrategy = new DefaultRequestedScopeLookupFunction();

    public void setScopeLookupStrategy(@Nonnull Function<ProfileRequestContext, Scope> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.scopeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ScopeLookupStrategy lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ResponseType responseType;
        Scope registeredScopes = this.getMetadataContext().getClientInformation().getMetadata().getScope();
        if (registeredScopes == null || registeredScopes.isEmpty()) {
            this.log.debug("{} No registered scopes for client {}, nothing to do", (Object)this.getLogPrefix(), (Object)this.getMetadataContext().getClientInformation().getID());
            return;
        }
        Scope requestedScopes = this.scopeLookupStrategy.apply(profileRequestContext);
        Iterator i = requestedScopes.iterator();
        while (i.hasNext()) {
            Scope.Value scope = (Scope.Value)i.next();
            if (registeredScopes.contains((Object)scope)) continue;
            this.log.warn("{} removing requested scope {} for rp {} as it is not a registered one", new Object[]{this.getLogPrefix(), scope.getValue(), this.getMetadataContext().getClientInformation().getID()});
            i.remove();
        }
        if (requestedScopes.contains((Object)OIDCScopeValue.OFFLINE_ACCESS) && (responseType = (ResponseType)new DefaultRequestResponseTypeLookupFunction().apply(profileRequestContext)) != null && !responseType.contains((Object)ResponseType.Value.CODE)) {
            requestedScopes.remove((Object)OIDCScopeValue.OFFLINE_ACCESS);
        }
        this.getOidcResponseContext().setScope(requestedScopes);
    }
}

