/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.logic;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscoderSupport;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeResolutionSubjectLookupFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    @NotEmpty
    private static final String subClaimName = "sub";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AttributeResolutionSubjectLookupFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @NonnullAfterInit
    private ReloadableService<AttributeTranscoderRegistry> transcoderRegistry;

    AttributeResolutionSubjectLookupFunction() {
    }

    public void setTranscoderRegistry(@Nonnull ReloadableService<AttributeTranscoderRegistry> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transcoderRegistry = (ReloadableService)Constraint.isNotNull(registry, (String)"AttributeTranscoderRegistry cannot be null");
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.transcoderRegistry == null) {
            throw new ComponentInitializationException("AttributeTranscoderRegistry cannot be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        AttributeContext attributeCtx = this.attributeContextLookupStrategy.apply(input);
        if (attributeCtx == null) {
            this.log.debug("No AttributeSubcontext available, nothing to do");
            return null;
        }
        ServiceableComponent component = null;
        try {
            component = this.transcoderRegistry.getServiceableComponent();
            if (component == null) {
                this.log.error("Attribute transoding service unavailable");
                String string = null;
                return string;
            }
            this.log.debug("Searching for 'sub' claim among encodeable attributes");
            for (IdPAttribute attribute : attributeCtx.getIdPAttributes().values()) {
                Collection transcodingRules;
                if (attribute == null || attribute.getValues().isEmpty() || (transcodingRules = ((AttributeTranscoderRegistry)component.getComponent()).getTranscodingRules(attribute, JSONObject.class)).isEmpty()) continue;
                for (TranscodingRule rule : transcodingRules) {
                    try {
                        String sub;
                        if (!subClaimName.equals(rule.getOrDefault("oidc.name", String.class, (Object)attribute.getId()))) continue;
                        this.log.debug("Found candidate rule for attribute '{}'", (Object)attribute.getId());
                        AttributeTranscoder transcoder = TranscoderSupport.getTranscoder((TranscodingRule)rule);
                        JSONObject encodedAttribute = (JSONObject)transcoder.encode(input, attribute, JSONObject.class, rule);
                        if (encodedAttribute == null || (sub = encodedAttribute.getAsString(subClaimName)) == null) continue;
                        this.log.debug("Attribute '{}' produced usable value for sub claim", (Object)attribute.getId());
                        String string = sub;
                        return string;
                    }
                    catch (AttributeEncodingException e) {
                        this.log.warn("Unable to encode attribute '{}' as OIDC claim", (Object)attribute.getId(), (Object)e);
                    }
                }
            }
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
        this.log.warn("Unable to produce a viable 'sub' claim");
        return null;
    }
}

