/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.logic;

import com.nimbusds.openid.connect.sdk.SubjectType;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.geant.idpextension.oidc.messaging.context.OIDCMetadataContext;
import org.geant.idpextension.oidc.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubjectTypeStrategy
implements Function<ProfileRequestContext, SubjectType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultSubjectTypeStrategy.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
    }

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadata lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public SubjectType apply(@Nullable ProfileRequestContext input) {
        SubjectType type = null;
        OIDCMetadataContext ctx = this.oidcMetadataContextLookupStrategy.apply(input);
        if (ctx != null && ctx.getClientInformation() != null && ctx.getClientInformation().getOIDCMetadata() != null) {
            type = ctx.getClientInformation().getOIDCMetadata().getSubjectType();
        }
        return type == null ? SubjectType.PUBLIC : type;
    }
}

