/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.profile.spring.factory;

import com.google.common.io.ByteStreams;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.spring.factory.AbstractCredentialFactoryBean;
import org.geant.idpextension.oidc.security.impl.CredentialConversionUtil;
import org.geant.security.jwk.BasicJWKCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.io.Resource;

public class BasicJWKCredentialFactoryBean
extends AbstractCredentialFactoryBean<BasicJWKCredential> {
    private final Logger log = LoggerFactory.getLogger(BasicJWKCredentialFactoryBean.class);
    private Resource jwkResource;

    public void setJWKResource(@Nonnull Resource res) {
        this.jwkResource = res;
    }

    protected BasicJWKCredential doCreateInstance() throws Exception {
        BasicJWKCredential jwkCredential;
        JWK jwk;
        block13: {
            if (this.jwkResource == null) {
                this.log.error("{}: No JWK credential provided", (Object)this.getConfigDescription());
                throw new BeanCreationException("No JWK credential provided");
            }
            jwk = null;
            jwkCredential = null;
            try (InputStream is = this.jwkResource.getInputStream();){
                jwk = JWK.parse((String)new String(ByteStreams.toByteArray((InputStream)is)));
                jwkCredential = new BasicJWKCredential();
                if (jwk.getKeyType() == KeyType.EC || jwk.getKeyType() == KeyType.RSA) {
                    if (jwk.isPrivate()) {
                        jwkCredential.setPrivateKey(((AsymmetricJWK)jwk).toPrivateKey());
                    }
                    jwkCredential.setPublicKey(((AsymmetricJWK)jwk).toPublicKey());
                    break block13;
                }
                if (jwk.getKeyType() == KeyType.OCT) {
                    jwkCredential.setSecretKey(((OctetSequenceKey)jwk).toSecretKey());
                    break block13;
                }
                throw new FatalBeanException("Unsupported KeyFile at " + this.jwkResource.getDescription());
            }
            catch (IOException | ParseException e) {
                this.log.error("{}: Could not decode KeyFile at {}: {}", new Object[]{this.getConfigDescription(), this.jwkResource.getDescription(), e});
                throw new FatalBeanException("Could not decode provided KeyFile " + this.jwkResource.getDescription(), (Throwable)e);
            }
        }
        jwkCredential.setUsageType(CredentialConversionUtil.getUsageType(jwk));
        jwkCredential.setEntityId(this.getEntityID());
        jwkCredential.setAlgorithm(jwk.getAlgorithm());
        jwkCredential.setKid(jwk.getKeyID());
        List keyNames = this.getKeyNames();
        if (keyNames != null) {
            jwkCredential.getKeyNames().addAll(keyNames);
        }
        return jwkCredential;
    }

    public Class<?> getObjectType() {
        return BasicJWKCredential.class;
    }
}

