/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.security.impl;

import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.geant.security.jwk.JWKCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;

public final class CredentialConversionUtil {
    private CredentialConversionUtil() {
    }

    public static String resolveKid(@Nonnull Credential credential) {
        Iterator iterator;
        if (credential.getKeyNames() != null && (iterator = credential.getKeyNames().iterator()).hasNext()) {
            String keyName = (String)iterator.next();
            return keyName;
        }
        if (credential instanceof JWKCredential) {
            return ((JWKCredential)credential).getKid();
        }
        return null;
    }

    public static KeyUse resolveKeyUse(Credential credential) {
        if (credential == null || credential.getUsageType() == null) {
            return null;
        }
        if (credential.getUsageType().equals((Object)UsageType.SIGNING)) {
            return KeyUse.SIGNATURE;
        }
        if (credential.getUsageType().equals((Object)UsageType.ENCRYPTION)) {
            return KeyUse.ENCRYPTION;
        }
        return null;
    }

    public static JWK credentialToKey(Credential credential) {
        if (credential == null || credential.getPublicKey() == null) {
            return null;
        }
        String algorithm = credential.getPublicKey().getAlgorithm();
        if ("RSA".equals(algorithm)) {
            return new RSAKey.Builder((RSAPublicKey)credential.getPublicKey()).keyUse(CredentialConversionUtil.resolveKeyUse(credential)).keyID(CredentialConversionUtil.resolveKid(credential)).build();
        }
        if ("EC".equals(algorithm)) {
            return new ECKey.Builder(Curve.forECParameterSpec((ECParameterSpec)((ECPublicKey)credential.getPublicKey()).getParams()), (ECPublicKey)credential.getPublicKey()).keyUse(CredentialConversionUtil.resolveKeyUse(credential)).keyID(CredentialConversionUtil.resolveKid(credential)).build();
        }
        return null;
    }

    public static UsageType getUsageType(@Nonnull JWK jwk) {
        if (KeyUse.ENCRYPTION.equals((Object)jwk.getKeyUse())) {
            return UsageType.ENCRYPTION;
        }
        if (KeyUse.SIGNATURE.equals((Object)jwk.getKeyUse())) {
            return UsageType.SIGNING;
        }
        return UsageType.UNSPECIFIED;
    }
}

