/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.security.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.geant.idpextension.oidc.security.impl.OIDCSignatureValidationParameters;
import org.geant.security.jwk.JWKCredential;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JWTSignatureValidationUtil {
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(JWTSignatureValidationUtil.class);

    private JWTSignatureValidationUtil() {
    }

    public static String validateSignature(SecurityParametersContext secParamCtx, SignedJWT signedJwt, String invalidJwtEventId) {
        if (secParamCtx == null) {
            log.error("No security parameters context is available");
            return "InvalidSecurityConfiguration";
        }
        if (secParamCtx.getSignatureSigningParameters() == null || !(secParamCtx.getSignatureSigningParameters() instanceof OIDCSignatureValidationParameters)) {
            log.error("No signature validation credentials available");
            return "InvalidSecurityConfiguration";
        }
        OIDCSignatureValidationParameters signatureValidationParameters = (OIDCSignatureValidationParameters)secParamCtx.getSignatureSigningParameters();
        JWSAlgorithm algorithm = signedJwt.getHeader().getAlgorithm();
        Iterator<JWKCredential> it = signatureValidationParameters.getValidationCredentials().iterator();
        boolean verified = false;
        while (it.hasNext()) {
            JWKCredential credential = it.next();
            if (!algorithm.equals((Object)credential.getAlgorithm())) {
                log.debug("Credential alg {} not matching jwt header alg {}", (Object)credential.getAlgorithm().getName(), (Object)algorithm.getName());
                if (it.hasNext()) {
                    log.debug("Unable to validate given JWT with credential, picking next key");
                    continue;
                }
                log.error("Unable to validate given JWT with any of the credentials");
                return invalidJwtEventId;
            }
            MACVerifier verifier = null;
            try {
                if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)algorithm)) {
                    verifier = new MACVerifier(credential.getSecretKey());
                }
                if (JWSAlgorithm.Family.RSA.contains((Object)algorithm)) {
                    verifier = new RSASSAVerifier((RSAPublicKey)credential.getPublicKey());
                }
                if (JWSAlgorithm.Family.EC.contains((Object)algorithm)) {
                    verifier = new ECDSAVerifier((ECPublicKey)credential.getPublicKey());
                }
                if (verifier == null) {
                    log.error("No verifier for given JWT for alg {}", (Object)algorithm.getName());
                    return "InvalidSecurityConfiguration";
                }
                if (!signedJwt.verify((JWSVerifier)verifier)) {
                    if (it.hasNext()) {
                        log.debug("Unable to validate given JWT with credential, picking next key");
                        continue;
                    }
                    log.error("Unable to validate given JWT with any of the credentials");
                    return invalidJwtEventId;
                }
                verified = true;
                log.debug("JWT {} verified using algorithm {} and key {}", new Object[]{signedJwt.serialize(), algorithm.getName(), credential.getKid()});
                break;
            }
            catch (JOSEException e) {
                if (it.hasNext()) {
                    log.debug("Unable to validate given JWT with credential, {}, picking next key", (Object)e.getMessage());
                    continue;
                }
                log.error("Unable to validate given JWT with any of the credentials, {}", (Object)e.getMessage());
                return invalidJwtEventId;
            }
        }
        if (!verified) {
            log.error("Unable to validate given JWT signature");
            return "InvalidSecurityConfiguration";
        }
        return null;
    }
}

