/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.security.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.criterion.ClientInformationCriterion;
import org.geant.idpextension.oidc.security.impl.OIDCDecryptionParameters;
import org.geant.security.jwk.BasicJWKCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionOptionalCriterion;
import org.opensaml.xmlsec.impl.BasicEncryptionParametersResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientInformationEncryptionParametersResolver
extends BasicEncryptionParametersResolver {
    private Logger log = LoggerFactory.getLogger(OIDCClientInformationEncryptionParametersResolver.class);
    private ParameterType target = ParameterType.IDTOKEN_ENCRYPTION;

    public void setParameterType(ParameterType value) {
        this.target = value;
    }

    @Nullable
    public EncryptionParameters resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        Constraint.isNotNull((Object)criteria, (String)"CriteriaSet was null");
        Constraint.isNotNull((Object)((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)), (String)"Resolver requires an instance of EncryptionConfigurationCriterion");
        Predicate whitelistBlacklistPredicate = this.getWhitelistBlacklistPredicate(criteria);
        OIDCDecryptionParameters params = this.target == ParameterType.REQUEST_OBJECT_DECRYPTION ? new OIDCDecryptionParameters() : new EncryptionParameters();
        this.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
        boolean encryptionOptional = false;
        EncryptionOptionalCriterion encryptionOptionalCrit = (EncryptionOptionalCriterion)criteria.get(EncryptionOptionalCriterion.class);
        if (encryptionOptionalCrit != null) {
            encryptionOptional = encryptionOptionalCrit.isEncryptionOptional();
        }
        if (this.validate(params, encryptionOptional)) {
            this.logResult(params);
            return params;
        }
        return null;
    }

    protected void resolveAndPopulateCredentialsAndAlgorithms(@Nonnull EncryptionParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        if (!criteria.contains(ClientInformationCriterion.class)) {
            this.log.debug("No client criterion, nothing to do");
            super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        OIDCClientInformation clientInformation = ((ClientInformationCriterion)criteria.get(ClientInformationCriterion.class)).getOidcClientInformation();
        if (clientInformation == null) {
            this.log.debug("No client information, nothing to do");
            super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        if (!criteria.contains(EncryptionConfigurationCriterion.class)) {
            this.log.debug("No encryption configuration criterion, nothing to do");
            super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        List encryptionConfigurations = ((EncryptionConfigurationCriterion)criteria.get(EncryptionConfigurationCriterion.class)).getConfigurations();
        if (encryptionConfigurations == null || encryptionConfigurations.isEmpty()) {
            this.log.debug("No encrypt configuration nothing to do");
            super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        JWEAlgorithm keyTransportAlgorithm = null;
        EncryptionMethod encryptionMethod = null;
        switch (this.target) {
            case REQUEST_OBJECT_DECRYPTION: {
                keyTransportAlgorithm = clientInformation.getOIDCMetadata().getRequestObjectJWEAlg();
                encryptionMethod = clientInformation.getOIDCMetadata().getRequestObjectJWEEnc();
                break;
            }
            case USERINFO_ENCRYPTION: {
                keyTransportAlgorithm = clientInformation.getOIDCMetadata().getUserInfoJWEAlg();
                encryptionMethod = clientInformation.getOIDCMetadata().getUserInfoJWEEnc();
                break;
            }
            default: {
                keyTransportAlgorithm = clientInformation.getOIDCMetadata().getIDTokenJWEAlg();
                encryptionMethod = clientInformation.getOIDCMetadata().getIDTokenJWEEnc();
            }
        }
        if (keyTransportAlgorithm == null) {
            this.log.debug("No algorithm information in client information, nothing to do");
            criteria.add((Object)new EncryptionOptionalCriterion(true));
            super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        if (encryptionMethod == null) {
            encryptionMethod = EncryptionMethod.A128CBC_HS256;
        }
        List keyTransportAlgorithms = this.getEffectiveKeyTransportAlgorithms(criteria, whitelistBlacklistPredicate);
        this.log.trace("Resolved effective key transport algorithms: {}", (Object)keyTransportAlgorithms);
        if (!keyTransportAlgorithms.contains(keyTransportAlgorithm.getName())) {
            this.log.warn("Client requests key transport algorithm {} that is not available", (Object)keyTransportAlgorithm.getName());
            super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        List dataEncryptionAlgorithms = this.getEffectiveDataEncryptionAlgorithms(criteria, whitelistBlacklistPredicate);
        this.log.trace("Resolved effective data encryption algorithms: {}", (Object)dataEncryptionAlgorithms);
        if (!dataEncryptionAlgorithms.contains(encryptionMethod.getName())) {
            this.log.warn("Client requests encryption algorithm {} that is not available", (Object)encryptionMethod.getName());
            super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        if (JWEAlgorithm.Family.SYMMETRIC.contains((Object)keyTransportAlgorithm)) {
            Secret secret = clientInformation.getSecret();
            if (secret == null) {
                this.log.warn("No client secret available");
                super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
                return;
            }
            BasicJWKCredential jwkCredential = new BasicJWKCredential();
            jwkCredential.setAlgorithm((Algorithm)keyTransportAlgorithm);
            try {
                jwkCredential.setSecretKey(this.generateSymmetricKey(secret.getValueBytes(), keyTransportAlgorithm));
            }
            catch (NoSuchAlgorithmException e) {
                this.log.warn("Unable to generate secret key: " + e.getMessage());
                super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
                return;
            }
            if (params instanceof OIDCDecryptionParameters) {
                ((OIDCDecryptionParameters)params).getKeyTransportDecryptionCredentials().add((Credential)jwkCredential);
            }
            params.setKeyTransportEncryptionCredential((Credential)jwkCredential);
            params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithm.getName());
            params.setDataEncryptionAlgorithm(encryptionMethod.getName());
            return;
        }
        if (this.target != ParameterType.REQUEST_OBJECT_DECRYPTION) {
            JWKSet keySet = clientInformation.getOIDCMetadata().getJWKSet();
            if (keySet == null) {
                this.log.warn("No keyset available");
                super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
                return;
            }
            for (JWK key : keySet.getKeys()) {
                if (KeyUse.SIGNATURE.equals((Object)key.getKeyUse()) || (!JWEAlgorithm.Family.RSA.contains((Object)keyTransportAlgorithm) || !key.getKeyType().equals((Object)KeyType.RSA)) && (!JWEAlgorithm.Family.ECDH_ES.contains((Object)keyTransportAlgorithm) || !key.getKeyType().equals((Object)KeyType.EC))) continue;
                BasicJWKCredential jwkCredential = new BasicJWKCredential();
                jwkCredential.setAlgorithm((Algorithm)keyTransportAlgorithm);
                jwkCredential.setKid(key.getKeyID());
                try {
                    if (key.getKeyType().equals((Object)KeyType.RSA)) {
                        jwkCredential.setPublicKey(((RSAKey)key).toPublicKey());
                    } else {
                        jwkCredential.setPublicKey(((ECKey)key).toPublicKey());
                    }
                }
                catch (JOSEException e) {
                    this.log.warn("Unable to parse keyset");
                    super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
                    return;
                }
                this.log.debug("Selected key {} for alg {} and enc {}", new Object[]{key.getKeyID(), keyTransportAlgorithm.getName(), encryptionMethod.getName()});
                params.setKeyTransportEncryptionCredential((Credential)jwkCredential);
                params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithm.getName());
                params.setDataEncryptionAlgorithm(encryptionMethod.getName());
                return;
            }
        } else {
            for (EncryptionConfiguration encryptionConfiguration : encryptionConfigurations) {
                for (Credential credential : encryptionConfiguration.getKeyTransportEncryptionCredentials()) {
                    if ((!JWEAlgorithm.Family.RSA.contains((Object)keyTransportAlgorithm) || !(credential.getPrivateKey() instanceof RSAPrivateKey)) && (!JWEAlgorithm.Family.ECDH_ES.contains((Object)keyTransportAlgorithm) || !(credential.getPrivateKey() instanceof ECPrivateKey))) continue;
                    this.log.debug("Picked key for alg {} and enc {}", (Object)keyTransportAlgorithm.getName(), (Object)encryptionMethod.getName());
                    params.setKeyTransportEncryptionCredential(credential);
                    params.setKeyTransportEncryptionAlgorithm(keyTransportAlgorithm.getName());
                    params.setDataEncryptionAlgorithm(encryptionMethod.getName());
                    if (params instanceof OIDCDecryptionParameters) {
                        ((OIDCDecryptionParameters)params).getKeyTransportDecryptionCredentials().add(credential);
                        continue;
                    }
                    return;
                }
            }
        }
        if (params.getKeyTransportEncryptionCredential() == null) {
            this.log.debug("Not able to credentials based on provided client information");
            super.resolveAndPopulateCredentialsAndAlgorithms(params, criteria, whitelistBlacklistPredicate);
        }
    }

    private SecretKey generateSymmetricKey(byte[] clientSecret, JWEAlgorithm keyTransportAlgorithm) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        switch (keyTransportAlgorithm.getName()) {
            case "A128KW": 
            case "A128GCMKW": {
                return new SecretKeySpec(md.digest(clientSecret), 0, 16, "AES");
            }
            case "A192KW": 
            case "A192GCMKW": {
                return new SecretKeySpec(md.digest(clientSecret), 0, 24, "AES");
            }
            case "A256KW": 
            case "A256GCMKW": {
                return new SecretKeySpec(md.digest(clientSecret), 0, 32, "AES");
            }
        }
        throw new NoSuchAlgorithmException("Implementation does not support generating key for " + keyTransportAlgorithm.getName());
    }

    public static enum ParameterType {
        REQUEST_OBJECT_DECRYPTION,
        IDTOKEN_ENCRYPTION,
        USERINFO_ENCRYPTION;

    }
}

