/*
 * Decompiled with CFR 0.152.
 */
package org.geant.idpextension.oidc.security.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.geant.idpextension.oidc.criterion.ClientInformationCriterion;
import org.geant.idpextension.oidc.security.impl.OIDCSignatureValidationParameters;
import org.geant.security.jwk.BasicJWKCredential;
import org.geant.security.jwk.JWKCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningParametersResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientInformationSignatureValidationParametersResolver
extends BasicSignatureSigningParametersResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(OIDCClientInformationSignatureValidationParametersResolver.class);
    private ParameterType target = ParameterType.REQUEST_OBJECT_VALIDATION;

    public void setParameterType(ParameterType value) {
        this.target = value;
    }

    @Nullable
    public SignatureSigningParameters resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        Constraint.isNotNull((Object)criteria, (String)"CriteriaSet was null");
        Constraint.isNotNull((Object)((SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class)), (String)"Resolver requires an instance of SignatureSigningConfigurationCriterion");
        Predicate whitelistBlacklistPredicate = this.getWhitelistBlacklistPredicate(criteria);
        OIDCSignatureValidationParameters params = new OIDCSignatureValidationParameters();
        this.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
        if (this.validate(params)) {
            if (params.getValidationCredentials().size() == 0) {
                BasicJWKCredential jwkCredential = new BasicJWKCredential();
                jwkCredential.setAlgorithm((Algorithm)JWSAlgorithm.parse((String)params.getSignatureAlgorithm()));
                jwkCredential.setPublicKey(params.getSigningCredential().getPublicKey());
                params.getValidationCredentials().add((JWKCredential)jwkCredential);
            }
            this.logResult(params);
            return params;
        }
        return null;
    }

    private boolean curveMatchesESAlgorithm(Curve curve, JWSAlgorithm algorithm) {
        if (algorithm.equals((Object)JWSAlgorithm.ES256)) {
            return curve.equals((Object)Curve.P_256);
        }
        if (algorithm.equals((Object)JWSAlgorithm.ES384)) {
            return curve.equals((Object)Curve.P_384);
        }
        if (algorithm.equals((Object)JWSAlgorithm.ES512)) {
            return curve.equals((Object)Curve.P_521);
        }
        return false;
    }

    protected void resolveAndPopulateCredentialAndSignatureAlgorithm(@Nonnull SignatureSigningParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        JWKSet keySet;
        JWSAlgorithm algorithm;
        this.log.debug("Resolving SignatureSigningParameters, purpose {}", (Object)(this.target.equals((Object)ParameterType.REQUEST_OBJECT_VALIDATION) ? "request object signature validation" : "token endpoint jwt signature validation"));
        if (!criteria.contains(ClientInformationCriterion.class)) {
            this.log.debug("No client criterion, nothing to do");
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        OIDCClientInformation clientInformation = ((ClientInformationCriterion)criteria.get(ClientInformationCriterion.class)).getOidcClientInformation();
        if (clientInformation == null) {
            this.log.debug("No client information, nothing to do");
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        List algorithms = this.getEffectiveSignatureAlgorithms(criteria, whitelistBlacklistPredicate);
        this.log.trace("Resolved effective signature algorithms: {}", (Object)algorithms);
        JWSAlgorithm jWSAlgorithm = algorithm = this.target == ParameterType.REQUEST_OBJECT_VALIDATION ? clientInformation.getOIDCMetadata().getRequestObjectJWSAlg() : clientInformation.getOIDCMetadata().getTokenEndpointAuthJWSAlg();
        if (algorithm != null && !algorithms.contains(algorithm.getName())) {
            this.log.warn("Client requests algorithm {} that is not available", (Object)algorithm.getName());
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        List<JWSAlgorithm> supportedAlgos = algorithm == null ? this.convertToJWSAlgorithmList(algorithms) : Arrays.asList(algorithm);
        for (JWSAlgorithm alg : supportedAlgos) {
            if (!JWSAlgorithm.Family.HMAC_SHA.contains((Object)alg)) continue;
            if (clientInformation.getSecret() == null) {
                this.log.debug("No client secret to use as a key");
                break;
            }
            BasicJWKCredential jwkCredential = new BasicJWKCredential();
            jwkCredential.setSecretKey((SecretKey)new SecretKeySpec(clientInformation.getSecret().getValueBytes(), "NONE"));
            jwkCredential.setAlgorithm((Algorithm)alg);
            this.log.trace("HS Credential initialized from client secret for algorithm {}", (Object)alg.getName());
            params.setSigningCredential((Credential)jwkCredential);
            params.setSignatureAlgorithm(alg.getName());
            ((OIDCSignatureValidationParameters)params).getValidationCredentials().add((JWKCredential)jwkCredential);
        }
        if ((keySet = clientInformation.getOIDCMetadata().getJWKSet()) == null) {
            this.log.debug("No keyset available");
        } else {
            for (JWK key : keySet.getKeys()) {
                if (KeyUse.ENCRYPTION.equals((Object)key.getKeyUse())) continue;
                for (JWSAlgorithm alg : supportedAlgos) {
                    if ((!JWSAlgorithm.Family.RSA.contains((Object)alg) || !(key instanceof RSAKey)) && (!JWSAlgorithm.Family.EC.contains((Object)alg) || !(key instanceof ECKey) || !this.curveMatchesESAlgorithm(((ECKey)key).getCurve(), alg))) continue;
                    BasicJWKCredential jwkCredential = new BasicJWKCredential();
                    jwkCredential.setAlgorithm((Algorithm)alg);
                    jwkCredential.setKid(key.getKeyID());
                    try {
                        jwkCredential.setPublicKey(((AsymmetricJWK)key).toPublicKey());
                    }
                    catch (JOSEException e) {
                        this.log.warn("Unable to parse key from keyset");
                        continue;
                    }
                    this.log.debug("Selected key {} for alg {}", (Object)key.getKeyID(), (Object)alg.getName());
                    params.setSigningCredential((Credential)jwkCredential);
                    params.setSignatureAlgorithm(alg.getName());
                    if (!(params instanceof OIDCSignatureValidationParameters)) continue;
                    ((OIDCSignatureValidationParameters)params).getValidationCredentials().add((JWKCredential)jwkCredential);
                }
            }
        }
        if (params.getSigningCredential() == null) {
            this.log.debug("Not able to resolve signature validation credential based on provided client information");
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
        }
    }

    private List<JWSAlgorithm> convertToJWSAlgorithmList(List<String> algorithms) {
        ArrayList<JWSAlgorithm> jwsList = new ArrayList<JWSAlgorithm>();
        if (algorithms == null) {
            return jwsList;
        }
        for (String algorithm : algorithms) {
            jwsList.add(JWSAlgorithm.parse((String)algorithm));
        }
        return jwsList;
    }

    protected boolean validate(@Nonnull SignatureSigningParameters params) {
        if (params.getSigningCredential() == null) {
            this.log.debug("Validation failure: Unable to resolve signature validation credential");
            return false;
        }
        if (params.getSignatureAlgorithm() == null) {
            this.log.debug("Validation failure: Unable to resolve signature validation algorithm URI");
            return false;
        }
        return true;
    }

    public static enum ParameterType {
        REQUEST_OBJECT_VALIDATION,
        TOKEN_ENDPOINT_JWT_VALIDATION;

    }
}

