/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.processor.output;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.codec.binary.Base64;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.impl.processor.output.EncryptOutputProcessor;
import org.apache.wss4j.stax.impl.processor.output.OutputProcessorUtils;
import org.apache.wss4j.stax.impl.processor.output.TimestampOutputProcessor;
import org.apache.wss4j.stax.impl.processor.output.WSSSignatureOutputProcessor;
import org.apache.wss4j.stax.impl.securityToken.OutboundUsernameSecurityToken;
import org.apache.wss4j.stax.utils.WSSUtils;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.AbstractOutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessor;
import org.apache.xml.security.stax.ext.OutputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.stax.XMLSecAttribute;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class UsernameTokenOutputProcessor
extends AbstractOutputProcessor {
    public UsernameTokenOutputProcessor() throws XMLSecurityException {
        this.addAfterProcessor(TimestampOutputProcessor.class.getName());
        this.addBeforeProcessor(WSSSignatureOutputProcessor.class.getName());
        this.addBeforeProcessor(EncryptOutputProcessor.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
        try {
            CallbackHandler callbackHandler = ((WSSSecurityProperties)this.getSecurityProperties()).getCallbackHandler();
            WSSConstants.UsernameTokenPasswordType usernameTokenPasswordType = ((WSSSecurityProperties)this.getSecurityProperties()).getUsernameTokenPasswordType();
            if (callbackHandler == null && WSSConstants.UsernameTokenPasswordType.PASSWORD_NONE != usernameTokenPasswordType) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
            }
            String password = null;
            if (callbackHandler != null) {
                WSPasswordCallback pwCb = new WSPasswordCallback(((WSSSecurityProperties)this.getSecurityProperties()).getTokenUser(), 2);
                WSSUtils.doPasswordCallback(callbackHandler, (Callback)pwCb);
                password = pwCb.getPassword();
            }
            if (password == null && WSSConstants.UsernameTokenPasswordType.PASSWORD_NONE != usernameTokenPasswordType) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE);
            }
            final String wsuId = IDGenerator.generateID(null);
            boolean useDerivedKeyForMAC = ((WSSSecurityProperties)this.getSecurityProperties()).isUseDerivedKeyForMAC();
            int derivedIterations = ((WSSSecurityProperties)this.getSecurityProperties()).getDerivedKeyIterations();
            byte[] salt = null;
            if (WSSConstants.USERNAMETOKEN_SIGNED.equals((Object)this.getAction())) {
                salt = UsernameTokenUtil.generateSalt((boolean)useDerivedKeyForMAC);
            }
            byte[] nonceValue = null;
            if (usernameTokenPasswordType == WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST || ((WSSSecurityProperties)this.getSecurityProperties()).isAddUsernameTokenNonce()) {
                nonceValue = WSSConstants.generateBytes((int)16);
            }
            XMLGregorianCalendar created = null;
            String createdStr = "";
            if (usernameTokenPasswordType == WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST || ((WSSSecurityProperties)this.getSecurityProperties()).isAddUsernameTokenCreated()) {
                created = WSSConstants.datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar(TimeZone.getTimeZone("UTC")));
                createdStr = created.toXMLFormat();
            }
            UsernameTokenOutputProcessor outputProcessor = this;
            final OutboundUsernameSecurityToken usernameSecurityToken = new OutboundUsernameSecurityToken(((WSSSecurityProperties)this.getSecurityProperties()).getTokenUser(), password, createdStr, nonceValue, wsuId, salt, derivedIterations);
            usernameSecurityToken.setProcessor((Object)outputProcessor);
            SecurityTokenProvider<OutboundSecurityToken> securityTokenProvider = new SecurityTokenProvider<OutboundSecurityToken>(){

                public OutboundSecurityToken getSecurityToken() throws WSSecurityException {
                    return usernameSecurityToken;
                }

                public String getId() {
                    return wsuId;
                }
            };
            if (WSSConstants.USERNAMETOKEN_SIGNED.equals((Object)this.getAction())) {
                outputProcessorChain.getSecurityContext().registerSecurityTokenProvider(wsuId, (SecurityTokenProvider)securityTokenProvider);
                outputProcessorChain.getSecurityContext().put("PROP_USE_THIS_TOKEN_ID_FOR_SIGNATURE", (Object)wsuId);
            }
            FinalUsernameTokenOutputProcessor finalUsernameTokenOutputProcessor = new FinalUsernameTokenOutputProcessor(wsuId, nonceValue, password, created, salt, derivedIterations, this.getAction());
            finalUsernameTokenOutputProcessor.setXMLSecurityProperties(this.getSecurityProperties());
            finalUsernameTokenOutputProcessor.setAction(this.getAction());
            finalUsernameTokenOutputProcessor.init(outputProcessorChain);
        }
        finally {
            outputProcessorChain.removeProcessor((OutputProcessor)this);
        }
        outputProcessorChain.processEvent(xmlSecEvent);
    }

    class FinalUsernameTokenOutputProcessor
    extends AbstractOutputProcessor {
        private String wsuId = null;
        private byte[] nonceValue = null;
        private String password = null;
        private XMLGregorianCalendar created = null;
        private byte[] salt;
        private int iterations;
        private XMLSecurityConstants.Action action;

        FinalUsernameTokenOutputProcessor(String wsuId, byte[] nonceValue, String password, XMLGregorianCalendar created, byte[] salt, int iterations, XMLSecurityConstants.Action action) throws XMLSecurityException {
            this.addAfterProcessor(UsernameTokenOutputProcessor.class.getName());
            this.addAfterProcessor(UsernameTokenOutputProcessor.class.getName());
            this.wsuId = wsuId;
            this.nonceValue = nonceValue;
            this.password = password;
            this.created = created;
            this.salt = salt;
            this.iterations = iterations;
            this.action = action;
        }

        public void processEvent(XMLSecEvent xmlSecEvent, OutputProcessorChain outputProcessorChain) throws XMLStreamException, XMLSecurityException {
            outputProcessorChain.processEvent(xmlSecEvent);
            if (WSSUtils.isSecurityHeaderElement(xmlSecEvent, ((WSSSecurityProperties)this.getSecurityProperties()).getActor())) {
                QName headerElementName = WSSConstants.TAG_wsse_UsernameToken;
                OutputProcessorUtils.updateSecurityHeaderOrder(outputProcessorChain, headerElementName, this.getAction(), false);
                OutputProcessorChain subOutputProcessorChain = outputProcessorChain.createSubChain((OutputProcessor)this);
                ArrayList<XMLSecAttribute> attributes = new ArrayList<XMLSecAttribute>(1);
                attributes.add(this.createAttribute(WSSConstants.ATT_wsu_Id, this.wsuId));
                this.createStartElementAndOutputAsEvent(subOutputProcessorChain, headerElementName, false, attributes);
                this.createStartElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse_Username, false, null);
                this.createCharactersAndOutputAsEvent(subOutputProcessorChain, ((WSSSecurityProperties)this.getSecurityProperties()).getTokenUser());
                this.createEndElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse_Username);
                if (((WSSSecurityProperties)this.getSecurityProperties()).getUsernameTokenPasswordType() != WSSConstants.UsernameTokenPasswordType.PASSWORD_NONE && !WSSConstants.USERNAMETOKEN_SIGNED.equals((Object)this.action)) {
                    attributes = new ArrayList(1);
                    attributes.add(this.createAttribute(WSSConstants.ATT_NULL_Type, ((WSSSecurityProperties)this.getSecurityProperties()).getUsernameTokenPasswordType() == WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST ? WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST.getNamespace() : WSSConstants.UsernameTokenPasswordType.PASSWORD_TEXT.getNamespace()));
                    this.createStartElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse_Password, false, attributes);
                    this.createCharactersAndOutputAsEvent(subOutputProcessorChain, ((WSSSecurityProperties)this.getSecurityProperties()).getUsernameTokenPasswordType() == WSSConstants.UsernameTokenPasswordType.PASSWORD_DIGEST ? WSSUtils.doPasswordDigest(this.nonceValue, this.created.toXMLFormat(), this.password) : this.password);
                    this.createEndElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse_Password);
                }
                if (this.salt != null) {
                    this.createStartElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse11_Salt, true, null);
                    this.createCharactersAndOutputAsEvent(subOutputProcessorChain, new Base64(76, new byte[]{10}).encodeToString(this.salt));
                    this.createEndElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse11_Salt);
                    if (this.iterations > 0) {
                        this.createStartElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse11_Iteration, true, null);
                        this.createCharactersAndOutputAsEvent(subOutputProcessorChain, "" + this.iterations);
                        this.createEndElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse11_Iteration);
                    }
                }
                if (this.nonceValue != null && !WSSConstants.USERNAMETOKEN_SIGNED.equals((Object)this.action)) {
                    attributes = new ArrayList(1);
                    attributes.add(this.createAttribute(WSSConstants.ATT_NULL_EncodingType, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary"));
                    this.createStartElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse_Nonce, false, attributes);
                    this.createCharactersAndOutputAsEvent(subOutputProcessorChain, new Base64(76, new byte[]{10}).encodeToString(this.nonceValue));
                    this.createEndElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsse_Nonce);
                }
                if (this.created != null && !WSSConstants.USERNAMETOKEN_SIGNED.equals((Object)this.action)) {
                    this.createStartElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsu_Created, false, null);
                    this.createCharactersAndOutputAsEvent(subOutputProcessorChain, this.created.toXMLFormat());
                    this.createEndElementAndOutputAsEvent(subOutputProcessorChain, WSSConstants.TAG_wsu_Created);
                }
                this.createEndElementAndOutputAsEvent(subOutputProcessorChain, headerElementName);
                outputProcessorChain.removeProcessor((OutputProcessor)this);
            }
        }
    }
}

