/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jaspi;

import io.undertow.security.api.AuthenticationMode;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.SecurityContextImpl;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.jboss.security.SecurityContext;
import org.jboss.security.auth.callback.JASPICallbackHandler;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.plugins.auth.JASPIServerAuthenticationManager;
import org.wildfly.extension.undertow.security.jaspi.SecurityActions;

class JASPICSecurityContext
extends SecurityContextImpl {
    private static final String layer = "HttpServlet";
    private static final CallbackHandler handler = new JASPICallbackHandler();
    private final HttpServerExchange exchange;
    private final JASPIServerAuthenticationManager manager;
    private Account cachedAuthenticatedAccount;

    public JASPICSecurityContext(HttpServerExchange exchange, AuthenticationMode mode, IdentityManager identityManager, String securityDomain) {
        super(exchange, mode, identityManager);
        this.exchange = exchange;
        this.manager = new JASPIServerAuthenticationManager(securityDomain, (CallbackHandler)new JBossCallbackHandler());
    }

    public boolean login(String username, String password) {
        String appContext = this.buildAppContext();
        AuthConfigProvider provider = AuthConfigFactory.getFactory().getConfigProvider(layer, appContext, null);
        if (provider != null) {
            ServletException se = new ServletException("login is not supported by the JASPIC mechanism");
            throw new SecurityException(se);
        }
        return super.login(username, password);
    }

    public void logout() {
        if (!this.isAuthenticated()) {
            return;
        }
        String appContext = this.buildAppContext();
        if (AuthConfigFactory.getFactory().getConfigProvider(layer, appContext, null) != null) {
            Subject authenticatedSubject = this.getAuthenticatedSubject();
            MessageInfo messageInfo = this.buildMessageInfo();
            this.manager.cleanSubject(messageInfo, authenticatedSubject, layer, appContext, handler);
        }
        super.logout();
    }

    public Account getAuthenticatedAccount() {
        Account account = super.getAuthenticatedAccount();
        if (account == null) {
            account = this.cachedAuthenticatedAccount;
        }
        return account;
    }

    public void setCachedAuthenticatedAccount(Account account) {
        this.cachedAuthenticatedAccount = account;
    }

    private String buildAppContext() {
        ServletRequestContext requestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest servletRequest = requestContext.getServletRequest();
        return servletRequest.getServletContext().getVirtualServerName() + " " + servletRequest.getServletContext().getContextPath();
    }

    private MessageInfo buildMessageInfo() {
        ServletRequestContext servletRequestContext = (ServletRequestContext)this.exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        GenericMessageInfo messageInfo = new GenericMessageInfo();
        messageInfo.setRequestMessage((Object)servletRequestContext.getServletRequest());
        messageInfo.setResponseMessage((Object)servletRequestContext.getServletResponse());
        messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", "true");
        return messageInfo;
    }

    private Subject getAuthenticatedSubject() {
        Subject subject = null;
        SecurityContext picketBoxContext = SecurityActions.getSecurityContext();
        if (picketBoxContext != null && picketBoxContext.getSubjectInfo() != null) {
            subject = picketBoxContext.getSubjectInfo().getAuthenticatedSubject();
        }
        return subject != null ? subject : new Subject();
    }
}

