/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.service;

import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.infinispan.spi.service.CacheContainerServiceName;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceName;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;

public class CacheBuilder<K, V>
implements Service<Cache<K, V>>,
Builder<Cache<K, V>> {
    private static final Logger log = Logger.getLogger(CacheBuilder.class);
    private final InjectedValue<EmbeddedCacheManager> container = new InjectedValue();
    private final String containerName;
    private final String cacheName;
    private volatile Cache<K, V> cache = null;

    public CacheBuilder(String containerName, String cacheName) {
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public ServiceName getServiceName() {
        return CacheServiceName.CACHE.getServiceName(this.containerName, this.cacheName);
    }

    public ServiceBuilder<Cache<K, V>> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)this).build(target).addDependency(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(this.containerName), EmbeddedCacheManager.class, this.container).addDependency(CacheServiceName.CONFIGURATION.getServiceName(this.containerName, this.cacheName)).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Cache<K, V> getValue() {
        return this.cache;
    }

    public void start(StartContext context) {
        this.cache = ((EmbeddedCacheManager)this.container.getValue()).getCache(this.cacheName);
        this.cache.start();
        log.debugf("%s %s cache started", (Object)this.cacheName, (Object)this.containerName);
    }

    public void stop(StopContext context) {
        this.cache.stop();
        this.cache = null;
        log.debugf("%s %s cache stopped", (Object)this.cacheName, (Object)this.containerName);
    }
}

