/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.integration;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.narayana.rest.integration.api.HeuristicException;
import org.jboss.narayana.rest.integration.api.HeuristicType;

@Provider
public class HeuristicMapper
implements ExceptionMapper<HeuristicException> {
    public Response toResponse(HeuristicException exception) {
        String status = this.heuristicTypeToTxStatus(exception.getHeuristicType());
        return Response.ok().entity((Object)TxSupport.toStatusContent((String)status)).build();
    }

    private String heuristicTypeToTxStatus(HeuristicType heuristicType) {
        switch (heuristicType) {
            case HEURISTIC_COMMIT: {
                return TxStatus.TransactionHeuristicCommit.name();
            }
            case HEURISTIC_HAZARD: {
                return TxStatus.TransactionHeuristicHazard.name();
            }
            case HEURISTIC_MIXED: {
                return TxStatus.TransactionHeuristicMixed.name();
            }
            case HEURISTIC_ROLLBACK: {
                return TxStatus.TransactionHeuristicRollback.name();
            }
        }
        throw new IllegalArgumentException("Unknown heuristic type");
    }
}

