/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.apache.activemq.artemis.api.jms.management.ConnectionFactoryControl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.AlternativeAttributeCheckHandler;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryDefinition;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class ConnectionFactoryWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final ConnectionFactoryWriteAttributeHandler INSTANCE = new ConnectionFactoryWriteAttributeHandler();

    private ConnectionFactoryWriteAttributeHandler() {
        super(ConnectionFactoryDefinition.ATTRIBUTES);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AlternativeAttributeCheckHandler(ConnectionFactoryDefinition.ATTRIBUTES), OperationContext.Stage.MODEL);
        super.execute(context, operation);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ServiceName serviceName;
        AttributeDefinition attr = this.getAttributeDefinition(attributeName);
        if (attr.getFlags().contains(AttributeAccess.Flag.RESTART_ALL_SERVICES)) {
            return true;
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service == null) {
            return false;
        }
        if (service.getState() != ServiceController.State.UP) {
            return true;
        }
        if (!ActiveMQActivationService.isActiveMQServerActive(context, operation)) {
            return false;
        }
        this.applyOperationToActiveMQService(context, this.getName(operation), attributeName, newValue, service);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null && service.getState() == ServiceController.State.UP) {
            this.applyOperationToActiveMQService(context, this.getName(operation), attributeName, valueToRestore, service);
        }
    }

    private String getName(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
    }

    private void applyOperationToActiveMQService(OperationContext context, String name, String attributeName, ModelNode value, ServiceController<?> serverServiceController) {
        block34: {
            if (attributeName.equals(ConnectionFactoryAttributes.Common.CONNECTORS.getName()) || attributeName.equals(ConnectionFactoryAttributes.Common.DISCOVERY_GROUP.getName())) {
                return;
            }
            ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(serverServiceController.getValue());
            ConnectionFactoryControl control = (ConnectionFactoryControl)ConnectionFactoryControl.class.cast(server.getManagementService().getResource("jms.connectionfactory." + name));
            try {
                if (attributeName.equals(CommonAttributes.CLIENT_ID.getName())) {
                    control.setClientID(value.isDefined() ? value.asString() : null);
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.COMPRESS_LARGE_MESSAGES.getName())) {
                    control.setCompressLargeMessages(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CLIENT_FAILURE_CHECK_PERIOD.getName())) {
                    control.setClientFailureCheckPeriod(value.asLong());
                    break block34;
                }
                if (attributeName.equals(CommonAttributes.CALL_TIMEOUT.getName())) {
                    control.setCallTimeout(value.asLong());
                    break block34;
                }
                if (attributeName.equals(CommonAttributes.CALL_FAILOVER_TIMEOUT.getName())) {
                    control.setCallFailoverTimeout(value.asLong());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.DUPS_OK_BATCH_SIZE.getName())) {
                    control.setDupsOKBatchSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONSUMER_MAX_RATE.getName())) {
                    control.setConsumerMaxRate(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONSUMER_WINDOW_SIZE.getName())) {
                    control.setConsumerWindowSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.PRODUCER_MAX_RATE.getName())) {
                    control.setProducerMaxRate(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONFIRMATION_WINDOW_SIZE.getName())) {
                    control.setConfirmationWindowSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.BLOCK_ON_ACKNOWLEDGE.getName())) {
                    control.setBlockOnAcknowledge(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.BLOCK_ON_DURABLE_SEND.getName())) {
                    control.setBlockOnDurableSend(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.BLOCK_ON_NON_DURABLE_SEND.getName())) {
                    control.setBlockOnNonDurableSend(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.PRE_ACKNOWLEDGE.getName())) {
                    control.setPreAcknowledge(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONNECTION_TTL.getName())) {
                    control.setConnectionTTL(value.asLong());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.TRANSACTION_BATCH_SIZE.getName())) {
                    control.setTransactionBatchSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(CommonAttributes.MIN_LARGE_MESSAGE_SIZE.getName())) {
                    control.setMinLargeMessageSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.AUTO_GROUP.getName())) {
                    control.setAutoGroup(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.RETRY_INTERVAL.getName())) {
                    control.setRetryInterval(value.asLong());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.RETRY_INTERVAL_MULTIPLIER.getName())) {
                    control.setRetryIntervalMultiplier(value.asDouble());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.RECONNECT_ATTEMPTS.getName())) {
                    control.setReconnectAttempts(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.FAILOVER_ON_INITIAL_CONNECTION.getName())) {
                    control.setFailoverOnInitialConnection(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.PRODUCER_WINDOW_SIZE.getName())) {
                    control.setProducerWindowSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CACHE_LARGE_MESSAGE_CLIENT.getName())) {
                    control.setCacheLargeMessagesClient(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(CommonAttributes.MAX_RETRY_INTERVAL.getName())) {
                    control.setMaxRetryInterval(value.asLong());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.SCHEDULED_THREAD_POOL_MAX_SIZE.getName())) {
                    control.setScheduledThreadPoolMaxSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.THREAD_POOL_MAX_SIZE.getName())) {
                    control.setThreadPoolMaxSize(value.asInt());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.GROUP_ID.getName())) {
                    control.setGroupID(value.isDefined() ? value.asString() : null);
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.USE_GLOBAL_POOLS.getName())) {
                    control.setUseGlobalPools(value.asBoolean());
                    break block34;
                }
                if (attributeName.equals(ConnectionFactoryAttributes.Common.CONNECTION_LOAD_BALANCING_CLASS_NAME.getName())) {
                    control.setConnectionLoadBalancingPolicyClassName(value.asString());
                    break block34;
                }
                throw MessagingLogger.ROOT_LOGGER.unsupportedRuntimeAttribute(attributeName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

