/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.txbridge.inbound;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.mw.wst11.UserTransactionFactory;
import com.arjuna.wsc.AlreadyRegisteredException;
import com.arjuna.wst.Durable2PCParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.Volatile2PCParticipant;
import com.arjuna.wst.WrongStateException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.jbossts.txbridge.inbound.BridgeDurableParticipant;
import org.jboss.jbossts.txbridge.inbound.BridgeVolatileParticipant;
import org.jboss.jbossts.txbridge.inbound.InboundBridge;
import org.jboss.jbossts.txbridge.utils.txbridgeLogger;

public class InboundBridgeManager {
    private static final ConcurrentMap<String, InboundBridge> inboundBridgeMappings = new ConcurrentHashMap<String, InboundBridge>();

    public static InboundBridge getInboundBridge() throws XAException, WrongStateException, UnknownTransactionException, SystemException, javax.transaction.SystemException, AlreadyRegisteredException {
        txbridgeLogger.logger.trace((Object)"InboundBridgeManager.getInboundBridge()");
        String externalTxId = UserTransactionFactory.userTransaction().toString();
        if (!inboundBridgeMappings.containsKey(externalTxId)) {
            InboundBridgeManager.createMapping(externalTxId);
        }
        return (InboundBridge)inboundBridgeMappings.get(externalTxId);
    }

    static InboundBridge getInboundBridge(String externalTxId) {
        return (InboundBridge)inboundBridgeMappings.get(externalTxId);
    }

    public static synchronized void removeMapping(String externalTxId) {
        txbridgeLogger.logger.trace((Object)("InboundBridgeManager.removeMapping(externalTxId=" + externalTxId + ")"));
        if (externalTxId != null) {
            inboundBridgeMappings.remove(externalTxId);
        }
    }

    private static synchronized void createMapping(String externalTxId) throws XAException, WrongStateException, UnknownTransactionException, SystemException, javax.transaction.SystemException, AlreadyRegisteredException {
        txbridgeLogger.logger.trace((Object)("InboundBridgeManager.createMapping(externalTxId=" + externalTxId + ")"));
        if (inboundBridgeMappings.containsKey(externalTxId)) {
            return;
        }
        TransactionManager transactionManager = TransactionManagerFactory.transactionManager();
        Xid xid = XATxConverter.getXid((Uid)new Uid(), (boolean)false, (int)131080);
        BridgeDurableParticipant bridgeDurableParticipant = new BridgeDurableParticipant(externalTxId, xid);
        String participantId = "BridgeDurableParticipant_" + new Uid().toString();
        transactionManager.enlistForDurableTwoPhase((Durable2PCParticipant)bridgeDurableParticipant, participantId);
        BridgeVolatileParticipant bridgeVolatileParticipant = new BridgeVolatileParticipant(externalTxId, xid);
        transactionManager.enlistForVolatileTwoPhase((Volatile2PCParticipant)bridgeVolatileParticipant, new Uid().toString());
        inboundBridgeMappings.put(externalTxId, new InboundBridge(xid));
    }
}

