/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.paths;

import org.hawkular.inventory.paths.SegmentType;

public interface ElementTypeVisitor<R, P> {
    public static <R, P> R accept(SegmentType entityType, ElementTypeVisitor<R, P> visitor, P parameter) {
        switch (entityType) {
            case t: {
                return visitor.visitTenant(parameter);
            }
            case e: {
                return visitor.visitEnvironment(parameter);
            }
            case f: {
                return visitor.visitFeed(parameter);
            }
            case m: {
                return visitor.visitMetric(parameter);
            }
            case mt: {
                return visitor.visitMetricType(parameter);
            }
            case r: {
                return visitor.visitResource(parameter);
            }
            case rt: {
                return visitor.visitResourceType(parameter);
            }
            case rl: {
                return visitor.visitRelationship(parameter);
            }
            case d: {
                return visitor.visitData(parameter);
            }
            case ot: {
                return visitor.visitOperationType(parameter);
            }
            case mp: {
                return visitor.visitMetadataPack(parameter);
            }
        }
        return visitor.visitUnknown(parameter);
    }

    public R visitTenant(P var1);

    public R visitEnvironment(P var1);

    public R visitFeed(P var1);

    public R visitMetric(P var1);

    public R visitMetricType(P var1);

    public R visitResource(P var1);

    public R visitResourceType(P var1);

    public R visitRelationship(P var1);

    public R visitData(P var1);

    public R visitOperationType(P var1);

    public R visitMetadataPack(P var1);

    public R visitUnknown(P var1);

    public static class Simple<R, P>
    implements ElementTypeVisitor<R, P> {
        private final R defaultValue;

        public Simple() {
            this(null);
        }

        public Simple(R defaultValue) {
            this.defaultValue = defaultValue;
        }

        protected R defaultAction(SegmentType elementType, P parameter) {
            return this.defaultValue;
        }

        @Override
        public R visitTenant(P parameter) {
            return this.defaultAction(SegmentType.t, parameter);
        }

        @Override
        public R visitEnvironment(P parameter) {
            return this.defaultAction(SegmentType.e, parameter);
        }

        @Override
        public R visitFeed(P parameter) {
            return this.defaultAction(SegmentType.f, parameter);
        }

        @Override
        public R visitMetric(P parameter) {
            return this.defaultAction(SegmentType.m, parameter);
        }

        @Override
        public R visitMetricType(P parameter) {
            return this.defaultAction(SegmentType.mt, parameter);
        }

        @Override
        public R visitResource(P parameter) {
            return this.defaultAction(SegmentType.r, parameter);
        }

        @Override
        public R visitResourceType(P parameter) {
            return this.defaultAction(SegmentType.rt, parameter);
        }

        @Override
        public R visitRelationship(P parameter) {
            return this.defaultAction(SegmentType.rl, parameter);
        }

        @Override
        public R visitData(P parameter) {
            return this.defaultAction(SegmentType.d, parameter);
        }

        @Override
        public R visitOperationType(P parameter) {
            return this.defaultAction(SegmentType.ot, parameter);
        }

        @Override
        public R visitMetadataPack(P parameter) {
            return this.defaultAction(SegmentType.mp, parameter);
        }

        @Override
        public R visitUnknown(P parameter) {
            return this.defaultAction(null, parameter);
        }
    }
}

