/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.remote.CompressedMethodsInformation;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.ejb.client.annotation.CompressionHint;

public class CompressionHintViewConfigurator
implements ViewConfigurator {
    public static final CompressionHintViewConfigurator INSTANCE = new CompressionHintViewConfigurator();

    private CompressionHintViewConfigurator() {
    }

    public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
        CompressedMethodsInformation value = CompressionHintViewConfigurator.getCompressedMethodsInformation(configuration.getViewClass());
        if (value != null) {
            configuration.getPrivateData().put(CompressedMethodsInformation.class, value);
        }
    }

    public static CompressedMethodsInformation getCompressedMethodsInformation(Class<?> viewClass) {
        Method[] methods = viewClass.getMethods();
        HashMap<Method, CompressionHint> hints = new HashMap<Method, CompressionHint>();
        boolean present = false;
        for (Method method : methods) {
            CompressionHint hint = method.getAnnotation(CompressionHint.class);
            if (hint == null) continue;
            hints.put(method, hint);
            present = true;
        }
        CompressionHint compression = viewClass.getAnnotation(CompressionHint.class);
        if (compression != null) {
            present = true;
        }
        CompressedMethodsInformation value = null;
        if (present) {
            value = new CompressedMethodsInformation(hints, compression);
        }
        return value;
    }
}

