/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.ejb3.subsystem.CacheFactoryResourceDefinition;
import org.jboss.as.ejb3.subsystem.ClusterPassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.DatabaseDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3IIOPResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3RemoteResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemNamespace;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLAttribute;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemXMLElement;
import org.jboss.as.ejb3.subsystem.FileDataStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.FilePassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.LegacyPassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.MdbDeliveryGroupResourceDefinition;
import org.jboss.as.ejb3.subsystem.PassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.RemoteConnectorChannelCreationOptionResource;
import org.jboss.as.ejb3.subsystem.RemotingEjbReceiverDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class EJB3SubsystemXMLPersister
implements XMLElementWriter<SubsystemMarshallingContext> {
    public static final EJB3SubsystemXMLPersister INSTANCE = new EJB3SubsystemXMLPersister();

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(EJB3SubsystemNamespace.EJB3_4_0.getUriString(), false);
        this.writeElements(writer, context);
        writer.writeEndElement();
    }

    protected void writeElements(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        ModelNode model = context.getModelNode();
        if (model.hasDefined("default-slsb-instance-pool") || model.hasDefined("default-stateful-bean-access-timeout") || model.hasDefined("default-singleton-bean-access-timeout")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.SESSION_BEAN.getLocalName());
        }
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.STATELESS.getLocalName());
            this.writeDefaultSLSBPool(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-stateful-bean-access-timeout") || model.hasDefined("default-sfsb-cache") || model.hasDefined("default-sfsb-passivation-disabled-cache")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.STATEFUL.getLocalName());
            this.writeStatefulBean(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-singleton-bean-access-timeout")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.SINGLETON.getLocalName());
            this.writeSingletonBean(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-slsb-instance-pool") || model.hasDefined("default-stateful-bean-access-timeout") || model.hasDefined("default-singleton-bean-access-timeout")) {
            writer.writeEndElement();
        }
        if (model.hasDefined("default-mdb-instance-pool") || model.hasDefined("default-resource-adapter-name") || model.hasDefined("mdb-delivery-group")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.MDB.getLocalName());
            this.writeMDB(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("default-entity-bean-instance-pool") || model.hasDefined("default-entity-bean-optimistic-locking")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.ENTITY_BEAN.getLocalName());
            this.writeEntityBean(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("strict-max-bean-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.POOLS.getLocalName());
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOLS.getLocalName());
            this.writeBeanInstancePools(writer, model);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        if (model.hasDefined("cache")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.CACHES.getLocalName());
            this.writeCaches(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("passivation-store") || model.hasDefined("cluster-passivation-store") || model.hasDefined("file-passivation-store")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.PASSIVATION_STORES.getLocalName());
            this.writePassivationStores(writer, model);
            this.writeFilePassivationStores(writer, model);
            this.writeClusterPassivationStores(writer, model);
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("async")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.ASYNC.getLocalName());
            this.writeAsync(writer, model.get(new String[]{"service", "async"}));
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("timer-service")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.TIMER_SERVICE.getLocalName());
            ModelNode timerServiceModel = model.get(new String[]{"service", "timer-service"});
            this.writeTimerService(writer, timerServiceModel);
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("remote")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.REMOTE.getLocalName());
            this.writeRemote(writer, model.get(new String[]{"service", "remote"}));
            if (model.hasDefined("remoting-profile")) {
                writer.writeStartElement(EJB3SubsystemXMLElement.PROFILES.getLocalName());
                this.writeProfiles(writer, model);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        if (model.hasDefined("thread-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.THREAD_POOLS.getLocalName());
            ModelNode threadsModel = model.get("thread-pool");
            this.writeThreadPools(writer, threadsModel);
            writer.writeEndElement();
        }
        if (model.hasDefined("service") && model.get("service").hasDefined("iiop")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.IIOP.getLocalName());
            this.writeIIOP(writer, model.get(new String[]{"service", "iiop"}));
            writer.writeEndElement();
        }
        if (model.hasDefined("in-vm-remote-interface-invocation-pass-by-value")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.IN_VM_REMOTE_INTERFACE_INVOCATION.getLocalName());
            writer.writeAttribute(EJB3SubsystemXMLAttribute.PASS_BY_VALUE.getLocalName(), model.get("in-vm-remote-interface-invocation-pass-by-value").asString());
            writer.writeEndElement();
        }
        if (model.hasDefined("default-distinct-name")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.DEFAULT_DISTINCT_NAME.getLocalName());
            writer.writeAttribute(EJB3SubsystemXMLAttribute.VALUE.getLocalName(), model.get("default-distinct-name").asString());
            writer.writeEndElement();
        }
        if (model.hasDefined("default-security-domain")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.DEFAULT_SECURITY_DOMAIN.getLocalName());
            writer.writeAttribute(EJB3SubsystemXMLAttribute.VALUE.getLocalName(), model.get("default-security-domain").asString());
            writer.writeEndElement();
        }
        if (model.hasDefined("default-missing-method-permissions-deny-access")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.DEFAULT_MISSING_METHOD_PERMISSIONS_DENY_ACCESS.getLocalName());
            writer.writeAttribute(EJB3SubsystemXMLAttribute.VALUE.getLocalName(), model.get("default-missing-method-permissions-deny-access").asString());
            writer.writeEndElement();
        }
        if (model.hasDefined("disable-default-ejb-permissions")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.DISABLE_DEFAULT_EJB_PERMISSIONS.getLocalName());
            writer.writeAttribute(EJB3SubsystemXMLAttribute.VALUE.getLocalName(), model.get("disable-default-ejb-permissions").asString());
            writer.writeEndElement();
        }
        if (model.hasDefined("enable-statistics")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.STATISTICS.getLocalName());
            writer.writeAttribute(EJB3SubsystemXMLAttribute.ENABLED.getLocalName(), model.get("enable-statistics").asString());
            writer.writeEndElement();
        }
        if (model.hasDefined("log-system-exceptions")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.LOG_SYSTEM_EXCEPTIONS.getLocalName());
            writer.writeAttribute(EJB3SubsystemXMLAttribute.VALUE.getLocalName(), model.get("log-system-exceptions").asString());
            writer.writeEndElement();
        }
    }

    private void writeIIOP(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        EJB3IIOPResourceDefinition.ENABLE_BY_DEFAULT.marshallAsAttribute(model, (XMLStreamWriter)writer);
        EJB3IIOPResourceDefinition.USE_QUALIFIED_NAME.marshallAsAttribute(model, (XMLStreamWriter)writer);
    }

    private void writeThreadPools(XMLExtendedStreamWriter writer, ModelNode threadPoolsModel) throws XMLStreamException {
        for (Property threadPool : threadPoolsModel.asPropertyList()) {
            ThreadsParser.getInstance().writeUnboundedQueueThreadPool(writer, threadPool, EJB3SubsystemXMLElement.THREAD_POOL.getLocalName(), true);
        }
    }

    protected void writeRemote(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("cluster")) {
            writer.writeAttribute(EJB3SubsystemXMLAttribute.CLIENT_MAPPINGS_CLUSTER_NAME.getLocalName(), model.require("cluster").asString());
        }
        writer.writeAttribute(EJB3SubsystemXMLAttribute.CONNECTOR_REF.getLocalName(), model.require("connector-ref").asString());
        writer.writeAttribute(EJB3SubsystemXMLAttribute.THREAD_POOL_NAME.getLocalName(), model.require("thread-pool-name").asString());
        EJB3RemoteResourceDefinition.EXECUTE_IN_WORKER.marshallAsAttribute(model, (XMLStreamWriter)writer);
        if (model.hasDefined("channel-creation-options")) {
            this.writeChannelCreationOptions(writer, model.get("channel-creation-options"));
        }
    }

    private void writeAsync(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        writer.writeAttribute(EJB3SubsystemXMLAttribute.THREAD_POOL_NAME.getLocalName(), model.require("thread-pool-name").asString());
    }

    private void writeMDB(XMLExtendedStreamWriter writer, ModelNode mdbModelNode) throws XMLStreamException {
        if (mdbModelNode.hasDefined("default-resource-adapter-name")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.RESOURCE_ADAPTER_REF.getLocalName());
            String resourceAdapterName = mdbModelNode.get("default-resource-adapter-name").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.RESOURCE_ADAPTER_NAME.getLocalName(), resourceAdapterName);
            writer.writeEndElement();
        }
        if (mdbModelNode.hasDefined("default-mdb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = mdbModelNode.get("default-mdb-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
        if (mdbModelNode.hasDefined("mdb-delivery-group")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.DELIVERY_GROUPS.getLocalName());
            for (Property property : mdbModelNode.get("mdb-delivery-group").asPropertyList()) {
                writer.writeStartElement(EJB3SubsystemXMLElement.DELIVERY_GROUP.getLocalName());
                writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
                MdbDeliveryGroupResourceDefinition.ACTIVE.marshallAsAttribute(mdbModelNode.get(new String[]{"mdb-delivery-group", property.getName()}), (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeEntityBean(XMLExtendedStreamWriter writer, ModelNode entityModelNode) throws XMLStreamException {
        if (entityModelNode.hasDefined("default-entity-bean-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = entityModelNode.get("default-entity-bean-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
        if (entityModelNode.hasDefined("default-entity-bean-optimistic-locking")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.OPTIMISTIC_LOCKING.getLocalName());
            Boolean locking = entityModelNode.get("default-entity-bean-optimistic-locking").asBoolean();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.ENABLED.getLocalName(), locking.toString());
            writer.writeEndElement();
        }
    }

    private void writeSingletonBean(XMLExtendedStreamWriter writer, ModelNode singletonBeanModel) throws XMLStreamException {
        String defaultAccessTimeout = singletonBeanModel.get("default-singleton-bean-access-timeout").asString();
        writer.writeAttribute(EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT.getLocalName(), defaultAccessTimeout);
    }

    private void writeStatefulBean(XMLExtendedStreamWriter writer, ModelNode statefulBeanModel) throws XMLStreamException {
        if (statefulBeanModel.hasDefined("default-stateful-bean-access-timeout")) {
            String defaultAccessTimeout = statefulBeanModel.get("default-stateful-bean-access-timeout").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.DEFAULT_ACCESS_TIMEOUT.getLocalName(), defaultAccessTimeout);
        }
        if (statefulBeanModel.hasDefined("default-sfsb-cache")) {
            String cache = statefulBeanModel.get("default-sfsb-cache").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.CACHE_REF.getLocalName(), cache);
        }
        EJB3SubsystemRootResourceDefinition.DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE.marshallAsAttribute(statefulBeanModel, (XMLStreamWriter)writer);
    }

    private void writeDefaultSLSBPool(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("default-slsb-instance-pool")) {
            writer.writeStartElement(EJB3SubsystemXMLElement.BEAN_INSTANCE_POOL_REF.getLocalName());
            String poolRefName = model.get("default-slsb-instance-pool").asString();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.POOL_NAME.getLocalName(), poolRefName);
            writer.writeEndElement();
        }
    }

    private void writeBeanInstancePools(XMLExtendedStreamWriter writer, ModelNode beanInstancePoolModelNode) throws XMLStreamException {
        if (beanInstancePoolModelNode.hasDefined("strict-max-bean-instance-pool")) {
            List strictMaxPools = beanInstancePoolModelNode.get("strict-max-bean-instance-pool").asPropertyList();
            for (Property property : strictMaxPools) {
                writer.writeStartElement(EJB3SubsystemXMLElement.STRICT_MAX_POOL.getLocalName());
                this.writeStrictMaxPoolConfig(writer, property);
                writer.writeEndElement();
            }
        }
    }

    private void writeStrictMaxPoolConfig(XMLExtendedStreamWriter writer, Property strictMaxPoolModel) throws XMLStreamException {
        ModelNode strictMaxPoolModelNode = strictMaxPoolModel.getValue();
        writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), strictMaxPoolModel.getName());
        StrictMaxPoolResourceDefinition.MAX_POOL_SIZE.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
        StrictMaxPoolResourceDefinition.DERIVE_SIZE.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
        StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
        StrictMaxPoolResourceDefinition.INSTANCE_ACQUISITION_TIMEOUT_UNIT.marshallAsAttribute(strictMaxPoolModelNode, (XMLStreamWriter)writer);
    }

    private void writeCaches(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        List caches = model.get("cache").asPropertyList();
        for (Property property : caches) {
            writer.writeStartElement(EJB3SubsystemXMLElement.CACHE.getLocalName());
            ModelNode cache = property.getValue();
            writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
            CacheFactoryResourceDefinition.PASSIVATION_STORE.marshallAsAttribute(cache, (XMLStreamWriter)writer);
            EJB3SubsystemXMLPersister.writeAttribute(writer, cache, (AttributeDefinition)CacheFactoryResourceDefinition.ALIASES);
            writer.writeEndElement();
        }
    }

    private void writePassivationStores(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("passivation-store")) {
            List caches = model.get("passivation-store").asPropertyList();
            for (Property property : caches) {
                writer.writeStartElement(EJB3SubsystemXMLElement.PASSIVATION_STORE.getLocalName());
                ModelNode store = property.getValue();
                writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
                PassivationStoreResourceDefinition.CACHE_CONTAINER.marshallAsAttribute(store, (XMLStreamWriter)writer);
                PassivationStoreResourceDefinition.BEAN_CACHE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                PassivationStoreResourceDefinition.MAX_SIZE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeClusterPassivationStores(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("cluster-passivation-store")) {
            List caches = model.get("cluster-passivation-store").asPropertyList();
            for (Property property : caches) {
                writer.writeStartElement(EJB3SubsystemXMLElement.CLUSTER_PASSIVATION_STORE.getLocalName());
                ModelNode store = property.getValue();
                writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
                LegacyPassivationStoreResourceDefinition.IDLE_TIMEOUT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                LegacyPassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                ClusterPassivationStoreResourceDefinition.MAX_SIZE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                ClusterPassivationStoreResourceDefinition.CACHE_CONTAINER.marshallAsAttribute(store, (XMLStreamWriter)writer);
                ClusterPassivationStoreResourceDefinition.BEAN_CACHE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                ClusterPassivationStoreResourceDefinition.CLIENT_MAPPINGS_CACHE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                ClusterPassivationStoreResourceDefinition.PASSIVATE_EVENTS_ON_REPLICATE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeFilePassivationStores(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (model.hasDefined("file-passivation-store")) {
            List caches = model.get("file-passivation-store").asPropertyList();
            for (Property property : caches) {
                writer.writeStartElement(EJB3SubsystemXMLElement.FILE_PASSIVATION_STORE.getLocalName());
                ModelNode store = property.getValue();
                writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
                LegacyPassivationStoreResourceDefinition.IDLE_TIMEOUT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                LegacyPassivationStoreResourceDefinition.IDLE_TIMEOUT_UNIT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.MAX_SIZE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.RELATIVE_TO.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.GROUPS_PATH.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.SESSIONS_PATH.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FilePassivationStoreResourceDefinition.SUBDIRECTORY_COUNT.marshallAsAttribute(store, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeTimerService(XMLExtendedStreamWriter writer, ModelNode timerServiceModel) throws XMLStreamException {
        TimerServiceResourceDefinition.THREAD_POOL_NAME.marshallAsAttribute(timerServiceModel, (XMLStreamWriter)writer);
        TimerServiceResourceDefinition.DEFAULT_DATA_STORE.marshallAsAttribute(timerServiceModel, (XMLStreamWriter)writer);
        writer.writeStartElement(EJB3SubsystemXMLElement.DATA_STORES.getLocalName());
        this.writeFileDataStores(writer, timerServiceModel);
        this.writeDatabaseDataStores(writer, timerServiceModel);
        writer.writeEndElement();
    }

    private void writeDatabaseDataStores(XMLExtendedStreamWriter writer, ModelNode timerServiceModel) throws XMLStreamException {
        if (timerServiceModel.hasDefined("database-data-store")) {
            List stores = timerServiceModel.get("database-data-store").asPropertyList();
            for (Property property : stores) {
                writer.writeStartElement(EJB3SubsystemXMLElement.DATABASE_DATA_STORE.getLocalName());
                ModelNode store = property.getValue();
                writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
                DatabaseDataStoreResourceDefinition.DATASOURCE_JNDI_NAME.marshallAsAttribute(store, (XMLStreamWriter)writer);
                DatabaseDataStoreResourceDefinition.DATABASE.marshallAsAttribute(store, (XMLStreamWriter)writer);
                DatabaseDataStoreResourceDefinition.PARTITION.marshallAsAttribute(store, (XMLStreamWriter)writer);
                DatabaseDataStoreResourceDefinition.REFRESH_INTERVAL.marshallAsAttribute(store, (XMLStreamWriter)writer);
                DatabaseDataStoreResourceDefinition.ALLOW_EXECUTION.marshallAsAttribute(store, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeFileDataStores(XMLExtendedStreamWriter writer, ModelNode timerServiceModel) throws XMLStreamException {
        if (timerServiceModel.hasDefined("file-data-store")) {
            List stores = timerServiceModel.get("file-data-store").asPropertyList();
            for (Property property : stores) {
                writer.writeStartElement(EJB3SubsystemXMLElement.FILE_DATA_STORE.getLocalName());
                ModelNode store = property.getValue();
                writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
                FileDataStoreResourceDefinition.PATH.marshallAsAttribute(store, (XMLStreamWriter)writer);
                FileDataStoreResourceDefinition.RELATIVE_TO.marshallAsAttribute(store, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeChannelCreationOptions(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(EJB3SubsystemXMLElement.CHANNEL_CREATION_OPTIONS.getLocalName());
        for (Property optionPropertyModelNode : node.asPropertyList()) {
            writer.writeStartElement(EJB3SubsystemXMLElement.OPTION.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), optionPropertyModelNode.getName());
            ModelNode propertyValueModelNode = optionPropertyModelNode.getValue();
            RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_VALUE.marshallAsAttribute(propertyValueModelNode, (XMLStreamWriter)writer);
            RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_TYPE.marshallAsAttribute(propertyValueModelNode, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeProfiles(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        List profiles = model.get("remoting-profile").asPropertyList();
        for (Property property : profiles) {
            writer.writeStartElement("profile");
            writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
            ModelNode profileNode = property.getValue();
            RemotingProfileResourceDefinition.EXCLUDE_LOCAL_RECEIVER.marshallAsAttribute(profileNode, (XMLStreamWriter)writer);
            RemotingProfileResourceDefinition.LOCAL_RECEIVER_PASS_BY_VALUE.marshallAsAttribute(profileNode, (XMLStreamWriter)writer);
            if (profileNode.hasDefined("remoting-ejb-receiver")) {
                this.writeRemotingEjbReceivers(writer, profileNode);
            }
            writer.writeEndElement();
        }
    }

    private void writeRemotingEjbReceivers(XMLExtendedStreamWriter writer, ModelNode profileNode) throws XMLStreamException {
        List receivers = profileNode.get("remoting-ejb-receiver").asPropertyList();
        for (Property property : receivers) {
            writer.writeStartElement("remoting-ejb-receiver");
            writer.writeAttribute(EJB3SubsystemXMLAttribute.NAME.getLocalName(), property.getName());
            ModelNode receiverNode = property.getValue();
            RemotingEjbReceiverDefinition.OUTBOUND_CONNECTION_REF.marshallAsAttribute(receiverNode, (XMLStreamWriter)writer);
            RemotingEjbReceiverDefinition.CONNECT_TIMEOUT.marshallAsAttribute(receiverNode, (XMLStreamWriter)writer);
            if (receiverNode.hasDefined("channel-creation-options")) {
                this.writeChannelCreationOptions(writer, receiverNode.get("channel-creation-options"));
            }
            writer.writeEndElement();
        }
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, AttributeDefinition attribute) throws XMLStreamException {
        attribute.getAttributeMarshaller().marshallAsAttribute(attribute, model, true, (XMLStreamWriter)writer);
    }
}

