/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.LocalEjbReceiver;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.as.ejb3.subsystem.RemoteConnectorChannelCreationOptionResource;
import org.jboss.as.ejb3.subsystem.RemotingEjbReceiverDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class RemotingProfileAdd
extends AbstractAddStepHandler {
    static final RemotingProfileAdd INSTANCE = new RemotingProfileAdd();

    private RemotingProfileAdd() {
        super(RemotingProfileResourceDefinition.ATTRIBUTES.values());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep((OperationStepHandler)ServiceInstallStepHandler.INSTANCE, OperationContext.Stage.RUNTIME);
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
    }

    protected void installServices(OperationContext context, PathAddress address, ModelNode profileNode) throws OperationFailedException {
        try {
            String profileName = address.getLastElement().getValue();
            ServiceName profileServiceName = RemotingProfileService.BASE_SERVICE_NAME.append(new String[]{profileName});
            RemotingProfileService profileService = new RemotingProfileService();
            ServiceBuilder builder = context.getServiceTarget().addService(profileServiceName, (Service)profileService);
            Boolean isLocalReceiverExcluded = RemotingProfileResourceDefinition.EXCLUDE_LOCAL_RECEIVER.resolveModelAttribute(context, profileNode).asBoolean();
            if (!isLocalReceiverExcluded.booleanValue()) {
                ModelNode passByValueNode = RemotingProfileResourceDefinition.LOCAL_RECEIVER_PASS_BY_VALUE.resolveModelAttribute(context, profileNode);
                if (passByValueNode.isDefined()) {
                    ServiceName localEjbReceiverServiceName = passByValueNode.asBoolean() ? LocalEjbReceiver.BY_VALUE_SERVICE_NAME : LocalEjbReceiver.BY_REFERENCE_SERVICE_NAME;
                    builder.addDependency(localEjbReceiverServiceName, LocalEjbReceiver.class, profileService.getLocalEjbReceiverInjector());
                } else {
                    builder.addDependency(LocalEjbReceiver.DEFAULT_LOCAL_EJB_RECEIVER_SERVICE_NAME, LocalEjbReceiver.class, profileService.getLocalEjbReceiverInjector());
                }
            }
            if (profileNode.hasDefined("remoting-ejb-receiver")) {
                for (Property receiverProperty : profileNode.get("remoting-ejb-receiver").asPropertyList()) {
                    ModelNode receiverNode = receiverProperty.getValue();
                    String connectionRef = RemotingEjbReceiverDefinition.OUTBOUND_CONNECTION_REF.resolveModelAttribute(context, receiverNode).asString();
                    long timeout = RemotingEjbReceiverDefinition.CONNECT_TIMEOUT.resolveModelAttribute(context, receiverNode).asLong();
                    profileService.addConnectionTimeout(connectionRef, timeout);
                    ServiceName connectionDependencyService = AbstractOutboundConnectionService.OUTBOUND_CONNECTION_BASE_SERVICE_NAME.append(new String[]{connectionRef});
                    InjectedValue connectionInjector = new InjectedValue();
                    builder.addDependency(connectionDependencyService, AbstractOutboundConnectionService.class, (Injector)connectionInjector);
                    profileService.addRemotingConnectionInjector(connectionDependencyService, (InjectedValue<AbstractOutboundConnectionService>)connectionInjector);
                    ModelNode channelCreationOptionsNode = receiverNode.get("channel-creation-options");
                    OptionMap channelCreationOptions = this.createChannelOptionMap(context, channelCreationOptionsNode);
                    profileService.addChannelCreationOption(connectionRef, channelCreationOptions);
                }
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (IllegalArgumentException e) {
            throw new OperationFailedException(e.getLocalizedMessage());
        }
    }

    private OptionMap createChannelOptionMap(OperationContext context, ModelNode channelCreationOptionsNode) throws OperationFailedException {
        OptionMap optionMap;
        if (channelCreationOptionsNode.isDefined()) {
            OptionMap.Builder optionMapBuilder = OptionMap.builder();
            ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
            for (Property optionProperty : channelCreationOptionsNode.asPropertyList()) {
                String name = optionProperty.getName();
                ModelNode propValueModel = optionProperty.getValue();
                String type = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_TYPE.resolveModelAttribute(context, propValueModel).asString();
                String optionClassName = this.getClassNameForChannelOptionType(type);
                String fullyQualifiedOptionName = optionClassName + "." + name;
                Option option = Option.fromString((String)fullyQualifiedOptionName, (ClassLoader)loader);
                String value = RemoteConnectorChannelCreationOptionResource.CHANNEL_CREATION_OPTION_VALUE.resolveModelAttribute(context, propValueModel).asString();
                optionMapBuilder.set(option, option.parseValue(value, loader));
            }
            optionMap = optionMapBuilder.getMap();
        } else {
            optionMap = OptionMap.EMPTY;
        }
        return optionMap;
    }

    private String getClassNameForChannelOptionType(String optionType) {
        if ("remoting".equals(optionType)) {
            return RemotingOptions.class.getName();
        }
        if ("xnio".equals(optionType)) {
            return Options.class.getName();
        }
        throw EjbLogger.ROOT_LOGGER.unknownChannelCreationOptionType(optionType);
    }

    private static class ServiceInstallStepHandler
    implements OperationStepHandler {
        private static final ServiceInstallStepHandler INSTANCE = new ServiceInstallStepHandler();

        private ServiceInstallStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode model = Resource.Tools.readModel((Resource)resource);
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            INSTANCE.installServices(context, address, model);
            context.stepCompleted();
        }
    }
}

