/*
 * Decompiled with CFR 0.152.
 */
package com.sun.codemodel;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationWriter;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDeclaration;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JGenerifiable;
import com.sun.codemodel.JGenerifiableImpl;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JMods;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.TypedAnnotationWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class JDefinedClass
extends JClass
implements JDeclaration,
JClassContainer,
JGenerifiable,
JAnnotatable,
JDocCommentable {
    private String name = null;
    private JMods mods;
    private JClass superClass;
    private final Set<JClass> interfaces = new TreeSet<JClass>();
    final Map<String, JFieldVar> fields = new LinkedHashMap<String, JFieldVar>();
    private JBlock init = null;
    private JBlock instanceInit = null;
    private JDocComment jdoc = null;
    private final List<JMethod> constructors = new ArrayList<JMethod>();
    private final List<JMethod> methods = new ArrayList<JMethod>();
    private Map<String, JDefinedClass> classes;
    private boolean hideFile = false;
    public Object metadata;
    private String directBlock;
    private JClassContainer outer = null;
    private final ClassType classType;
    private final Map<String, JEnumConstant> enumConstantsByName = new LinkedHashMap<String, JEnumConstant>();
    private List<JAnnotationUse> annotations = null;
    private final JGenerifiableImpl generifiable = new JGenerifiableImpl(){

        @Override
        protected JCodeModel owner() {
            return JDefinedClass.this.owner();
        }
    };

    JDefinedClass(JClassContainer parent, int mods, String name, ClassType classTypeval) {
        this(mods, name, parent, parent.owner(), classTypeval);
    }

    JDefinedClass(JCodeModel owner, int mods, String name) {
        this(mods, name, null, owner);
    }

    private JDefinedClass(int mods, String name, JClassContainer parent, JCodeModel owner) {
        this(mods, name, parent, owner, ClassType.CLASS);
    }

    private JDefinedClass(int mods, String name, JClassContainer parent, JCodeModel owner, ClassType classTypeVal) {
        super(owner);
        if (name != null) {
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException("JClass name empty");
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                String msg = "JClass name " + name + " contains illegal character" + " for beginning of identifier: " + name.charAt(0);
                throw new IllegalArgumentException(msg);
            }
            for (int i = 1; i < name.length(); ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                String msg = "JClass name " + name + " contains illegal character " + name.charAt(i);
                throw new IllegalArgumentException(msg);
            }
        }
        this.classType = classTypeVal;
        this.mods = this.isInterface() ? JMods.forInterface(mods) : JMods.forClass(mods);
        this.name = name;
        this.outer = parent;
    }

    public final boolean isAnonymous() {
        return this.name == null;
    }

    public JDefinedClass _extends(JClass superClass) {
        if (this.classType == ClassType.INTERFACE) {
            if (superClass.isInterface()) {
                return this._implements(superClass);
            }
            throw new IllegalArgumentException("unable to set the super class for an interface");
        }
        if (superClass == null) {
            throw new NullPointerException();
        }
        for (JClass o = superClass.outer(); o != null; o = o.outer()) {
            if (this != o) continue;
            throw new IllegalArgumentException("Illegal class inheritance loop.  Outer class " + this.name + " may not subclass from inner class: " + o.name());
        }
        this.superClass = superClass;
        return this;
    }

    public JDefinedClass _extends(Class<?> superClass) {
        return this._extends(this.owner().ref(superClass));
    }

    @Override
    public JClass _extends() {
        if (this.superClass == null) {
            this.superClass = this.owner().ref(Object.class);
        }
        return this.superClass;
    }

    public JDefinedClass _implements(JClass iface) {
        this.interfaces.add(iface);
        return this;
    }

    public JDefinedClass _implements(Class<?> iface) {
        return this._implements(this.owner().ref(iface));
    }

    @Override
    public Iterator<JClass> _implements() {
        return this.interfaces.iterator();
    }

    @Override
    public String name() {
        return this.name;
    }

    public JEnumConstant enumConstant(String name) {
        JEnumConstant ec = this.enumConstantsByName.get(name);
        if (null == ec) {
            ec = new JEnumConstant(this, name);
            this.enumConstantsByName.put(name, ec);
        }
        return ec;
    }

    @Override
    public String fullName() {
        if (this.outer instanceof JDefinedClass) {
            return ((JDefinedClass)this.outer).fullName() + '.' + this.name();
        }
        JPackage p = this._package();
        if (p.isUnnamed()) {
            return this.name();
        }
        return p.name() + '.' + this.name();
    }

    @Override
    public String binaryName() {
        if (this.outer instanceof JDefinedClass) {
            return ((JDefinedClass)this.outer).binaryName() + '$' + this.name();
        }
        return this.fullName();
    }

    @Override
    public boolean isInterface() {
        return this.classType == ClassType.INTERFACE;
    }

    @Override
    public boolean isAbstract() {
        return this.mods.isAbstract();
    }

    public JFieldVar field(int mods, JType type, String name) {
        return this.field(mods, type, name, null);
    }

    public JFieldVar field(int mods, Class<?> type, String name) {
        return this.field(mods, this.owner()._ref(type), name);
    }

    public JFieldVar field(int mods, JType type, String name, JExpression init) {
        JFieldVar f = new JFieldVar(this, JMods.forField(mods), type, name, init);
        if (this.fields.containsKey(name)) {
            throw new IllegalArgumentException("trying to create the same field twice: " + name);
        }
        this.fields.put(name, f);
        return f;
    }

    public boolean isAnnotationTypeDeclaration() {
        return this.classType == ClassType.ANNOTATION_TYPE_DECL;
    }

    @Override
    public JDefinedClass _annotationTypeDeclaration(String name) throws JClassAlreadyExistsException {
        return this._class(1, name, ClassType.ANNOTATION_TYPE_DECL);
    }

    @Override
    public JDefinedClass _enum(String name) throws JClassAlreadyExistsException {
        return this._class(1, name, ClassType.ENUM);
    }

    public JDefinedClass _enum(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, ClassType.ENUM);
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public JFieldVar field(int mods, Class<?> type, String name, JExpression init) {
        return this.field(mods, this.owner()._ref(type), name, init);
    }

    public Map<String, JFieldVar> fields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public void removeField(JFieldVar field) {
        if (this.fields.remove(field.name()) != field) {
            throw new IllegalArgumentException();
        }
    }

    public JBlock init() {
        if (this.init == null) {
            this.init = new JBlock();
        }
        return this.init;
    }

    public JBlock instanceInit() {
        if (this.instanceInit == null) {
            this.instanceInit = new JBlock();
        }
        return this.instanceInit;
    }

    public JMethod constructor(int mods) {
        JMethod c = new JMethod(mods, this);
        this.constructors.add(c);
        return c;
    }

    public Iterator<JMethod> constructors() {
        return this.constructors.iterator();
    }

    public JMethod getConstructor(JType[] argTypes) {
        for (JMethod m : this.constructors) {
            if (!m.hasSignature(argTypes)) continue;
            return m;
        }
        return null;
    }

    public JMethod method(int mods, JType type, String name) {
        JMethod m = new JMethod(this, mods, type, name);
        this.methods.add(m);
        return m;
    }

    public JMethod method(int mods, Class<?> type, String name) {
        return this.method(mods, this.owner()._ref(type), name);
    }

    public Collection<JMethod> methods() {
        return this.methods;
    }

    public JMethod getMethod(String name, JType[] argTypes) {
        for (JMethod m : this.methods) {
            if (!m.name().equals(name) || !m.hasSignature(argTypes)) continue;
            return m;
        }
        return null;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isPackage() {
        return false;
    }

    @Override
    public JPackage getPackage() {
        return this.parentContainer().getPackage();
    }

    @Override
    public JDefinedClass _class(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, ClassType.CLASS);
    }

    @Override
    public JDefinedClass _class(int mods, String name, boolean isInterface) throws JClassAlreadyExistsException {
        return this._class(mods, name, isInterface ? ClassType.INTERFACE : ClassType.CLASS);
    }

    @Override
    public JDefinedClass _class(int mods, String name, ClassType classTypeVal) throws JClassAlreadyExistsException {
        String NAME = JCodeModel.isCaseSensitiveFileSystem ? name.toUpperCase() : name;
        if (this.getClasses().containsKey(NAME)) {
            throw new JClassAlreadyExistsException(this.getClasses().get(NAME));
        }
        JDefinedClass c = new JDefinedClass(this, mods, name, classTypeVal);
        this.getClasses().put(NAME, c);
        return c;
    }

    @Override
    public JDefinedClass _class(String name) throws JClassAlreadyExistsException {
        return this._class(1, name);
    }

    @Override
    public JDefinedClass _interface(int mods, String name) throws JClassAlreadyExistsException {
        return this._class(mods, name, ClassType.INTERFACE);
    }

    @Override
    public JDefinedClass _interface(String name) throws JClassAlreadyExistsException {
        return this._interface(1, name);
    }

    @Override
    public JDocComment javadoc() {
        if (this.jdoc == null) {
            this.jdoc = new JDocComment(this.owner());
        }
        return this.jdoc;
    }

    public void hide() {
        this.hideFile = true;
    }

    public boolean isHidden() {
        return this.hideFile;
    }

    @Override
    public final Iterator<JDefinedClass> classes() {
        if (this.classes == null) {
            return Collections.emptyList().iterator();
        }
        return this.classes.values().iterator();
    }

    private Map<String, JDefinedClass> getClasses() {
        if (this.classes == null) {
            this.classes = new TreeMap<String, JDefinedClass>();
        }
        return this.classes;
    }

    public final JClass[] listClasses() {
        if (this.classes == null) {
            return new JClass[0];
        }
        return this.classes.values().toArray(new JClass[this.classes.values().size()]);
    }

    @Override
    public JClass outer() {
        if (this.outer.isClass()) {
            return (JClass)((Object)this.outer);
        }
        return null;
    }

    @Override
    public void declare(JFormatter f) {
        if (this.jdoc != null) {
            f.nl().g(this.jdoc);
        }
        if (this.annotations != null) {
            for (JAnnotationUse annotation : this.annotations) {
                f.g(annotation).nl();
            }
        }
        f.g(this.mods).p(this.classType.declarationToken).id(this.name).d(this.generifiable);
        if (this.superClass != null && this.superClass != this.owner().ref(Object.class)) {
            f.nl().i().p("extends").g(this.superClass).nl().o();
        }
        if (!this.interfaces.isEmpty()) {
            if (this.superClass == null) {
                f.nl();
            }
            f.i().p(this.classType == ClassType.INTERFACE ? "extends" : "implements");
            f.g(this.interfaces);
            f.nl().o();
        }
        this.declareBody(f);
    }

    protected void declareBody(JFormatter f) {
        f.p('{').nl().nl().i();
        boolean first = true;
        if (!this.enumConstantsByName.isEmpty()) {
            for (JEnumConstant c : this.enumConstantsByName.values()) {
                if (!first) {
                    f.p(',').nl();
                }
                f.d(c);
                first = false;
            }
            f.p(';').nl();
        }
        for (JFieldVar field : this.fields.values()) {
            f.d(field);
        }
        if (this.init != null) {
            f.nl().p("static").s(this.init);
        }
        if (this.instanceInit != null) {
            f.nl().s(this.instanceInit);
        }
        for (JMethod m : this.constructors) {
            f.nl().d(m);
        }
        for (JMethod m : this.methods) {
            f.nl().d(m);
        }
        if (this.classes != null) {
            for (JDefinedClass dc : this.classes.values()) {
                f.nl().d(dc);
            }
        }
        if (this.directBlock != null) {
            f.p(this.directBlock);
        }
        f.nl().o().p('}').nl();
    }

    public void direct(String string) {
        this.directBlock = this.directBlock == null ? string : this.directBlock + string;
    }

    @Override
    public final JPackage _package() {
        JClassContainer p = this.outer;
        while (!(p instanceof JPackage)) {
            p = p.parentContainer();
        }
        return (JPackage)p;
    }

    @Override
    public final JClassContainer parentContainer() {
        return this.outer;
    }

    @Override
    public JTypeVar generify(String name) {
        return this.generifiable.generify(name);
    }

    @Override
    public JTypeVar generify(String name, Class<?> bound) {
        return this.generifiable.generify(name, bound);
    }

    @Override
    public JTypeVar generify(String name, JClass bound) {
        return this.generifiable.generify(name, bound);
    }

    @Override
    public JTypeVar[] typeParams() {
        return this.generifiable.typeParams();
    }

    @Override
    protected JClass substituteParams(JTypeVar[] variables, List<JClass> bindings) {
        return this;
    }

    @Override
    public JAnnotationUse annotate(Class<? extends Annotation> clazz) {
        return this.annotate(this.owner().ref(clazz));
    }

    @Override
    public JAnnotationUse annotate(JClass clazz) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<JAnnotationUse>();
        }
        JAnnotationUse a = new JAnnotationUse(clazz);
        this.annotations.add(a);
        return a;
    }

    @Override
    public <W extends JAnnotationWriter> W annotate2(Class<W> clazz) {
        return TypedAnnotationWriter.create(clazz, this);
    }

    @Override
    public boolean removeAnnotation(JAnnotationUse annotation) {
        return this.annotations.remove(annotation);
    }

    @Override
    public Collection<JAnnotationUse> annotations() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<JAnnotationUse>();
        }
        return Collections.unmodifiableCollection(this.annotations);
    }

    public JMods mods() {
        return this.mods;
    }
}

