/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyInstance;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.LocationResolver;
import org.jgrapht.alg.DirectedNeighborIndex;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.event.VertexSetListener;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.ListenableDirectedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.DepthFirstIterator;

public final class ResourceManager<L> {
    private static final MsgLogger log = AgentLoggers.getLogger(ResourceManager.class);
    private final ReadWriteLock graphLock = new ReentrantReadWriteLock(true);
    private final Lock graphLockRead = this.graphLock.readLock();
    private final Lock graphLockWrite = this.graphLock.writeLock();
    private volatile DirectedNeighborIndex<Resource<L>, DefaultEdge> neighborIndex;
    private volatile Map<ID, Resource<L>> resourceCache;
    private volatile ListenableDirectedGraph<Resource<L>, DefaultEdge> resourcesGraph;

    public ResourceManager() {
        this.reinitializeIfNecessary();
    }

    public int size() {
        return this.resourceCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Resource<L> relativeTo) {
        this.graphLockRead.lock();
        try {
            if (this.getResource(relativeTo.getID()) == null) {
                int n = 0;
                return n;
            }
            ArrayList<Resource<L>> descendants = new ArrayList<Resource<L>>();
            this.getAllDescendants(relativeTo, descendants);
            int n = 1 + descendants.size();
            return n;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddResult<L> addResource(Resource<L> newResource) throws IllegalArgumentException {
        this.graphLockWrite.lock();
        try {
            AddResult<L> result;
            boolean added;
            if (newResource.getParent() != null) {
                Resource<L> parentInGraph = this.getResource(newResource.getParent().getID());
                if (parentInGraph == null) {
                    throw new IllegalArgumentException(String.format("The new resource [%s] has a parent [%s] that has not been added yet", newResource, newResource.getParent()));
                }
                if (parentInGraph != newResource.getParent()) {
                    newResource = Resource.builder(newResource).parent(parentInGraph).build();
                }
            }
            if (!(added = this.resourcesGraph.addVertex(newResource))) {
                Resource<L> oldResource = this.getResource(newResource.getID());
                if (new ResourceComparator().compare(oldResource, newResource) != 0) {
                    Set<Resource<L>> children = this.getChildren(oldResource);
                    this.resourcesGraph.removeVertex(oldResource);
                    this.resourcesGraph.addVertex(newResource);
                    for (Resource<L> child : children) {
                        this.resourcesGraph.addEdge(newResource, child);
                    }
                    result = new AddResult<L>(AddResult.Effect.MODIFIED, newResource);
                } else {
                    result = new AddResult<L>(AddResult.Effect.UNCHANGED, oldResource);
                }
            } else {
                result = new AddResult<L>(AddResult.Effect.ADDED, newResource);
            }
            if (result.getEffect() != AddResult.Effect.UNCHANGED && newResource.getParent() != null) {
                this.resourcesGraph.addEdge(newResource.getParent(), newResource);
            }
            AddResult<L> addResult = result;
            return addResult;
        }
        finally {
            this.graphLockWrite.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource<L>> removeResource(Resource<L> doomedResource) {
        this.graphLockWrite.lock();
        try {
            ArrayList<Resource<L>> removedResources = new ArrayList<Resource<L>>();
            Resource<L> resourceToRemove = this.getResource(doomedResource.getID());
            if (resourceToRemove != null) {
                this.getAllDescendants(resourceToRemove, removedResources);
                removedResources.add(resourceToRemove);
                removedResources.forEach(r -> this.resourcesGraph.removeVertex(r));
            }
            List<Resource<L>> list = Collections.unmodifiableList(removedResources);
            return list;
        }
        finally {
            this.graphLockWrite.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource<L>> findResources(L query, LocationResolver<L> locationResolver) {
        this.graphLockRead.lock();
        try {
            ArrayList<Resource> result = new ArrayList<Resource>();
            BreadthFirstIterator it = new BreadthFirstIterator(this.resourcesGraph);
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                if (!locationResolver.matches(query, resource.getLocation())) continue;
                result.add(resource);
            }
            List<Resource<L>> list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Resource<L>> getChildren(Resource<L> resource) {
        this.graphLockRead.lock();
        try {
            Set directChildren = this.neighborIndex.successorsOf(resource);
            Set<Resource<L>> set = Collections.unmodifiableSet(new HashSet(directChildren));
            return set;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource<L> getParent(Resource<L> resource) {
        this.graphLockRead.lock();
        try {
            Set directParents = this.neighborIndex.predecessorsOf(resource);
            if (directParents.isEmpty()) {
                Resource<L> resource2 = null;
                return resource2;
            }
            Resource resource3 = (Resource)directParents.iterator().next();
            return resource3;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    public Resource<L> getResource(ID resourceId) {
        this.graphLockRead.lock();
        try {
            Resource<L> resource = this.resourceCache.get(resourceId);
            return resource;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource<L>> getResourcesBreadthFirst() {
        this.graphLockRead.lock();
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            Set<Resource<L>> roots = this.getRootResources();
            if (roots.isEmpty()) {
                List<Resource<L>> list = Collections.emptyList();
                return list;
            }
            for (Resource<L> root : roots) {
                BreadthFirstIterator it = new BreadthFirstIterator(this.resourcesGraph, root);
                while (it.hasNext()) {
                    result.add(it.next());
                }
            }
            List list = Collections.unmodifiableList(result);
            return list;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource<L>> getAllResources(Collection<ID> filter) {
        this.graphLockRead.lock();
        try {
            HashSet<ID> resultIds = new HashSet<ID>(this.resourceCache.keySet());
            if (filter != null) {
                resultIds.removeAll(filter);
            }
            List<Resource<L>> list = resultIds.stream().map(i -> this.getResource((ID)i)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Resource<L>> getRootResources() {
        this.graphLockRead.lock();
        try {
            HashSet<Resource> roots = new HashSet<Resource>();
            Set allResources = this.resourcesGraph.vertexSet();
            for (Resource resource : allResources) {
                if (!this.neighborIndex.predecessorsOf((Object)resource).isEmpty()) continue;
                roots.add(resource);
            }
            Set set = Collections.unmodifiableSet(roots);
            return set;
        }
        finally {
            this.graphLockRead.unlock();
        }
    }

    public void logTreeGraph(String logMsg, long duration) {
        if (!log.isDebugEnabled()) {
            return;
        }
        try {
            StringBuilder graphString = new StringBuilder();
            for (Resource<L> resource : this.getResourcesBreadthFirst()) {
                for (Resource<L> parent = resource.getParent(); parent != null; parent = parent.getParent()) {
                    graphString.append("...");
                }
                graphString.append(resource).append("\n");
            }
            log.debugf("%s\n%s\nDiscovery duration: [%d]ms", logMsg, graphString, duration);
        }
        catch (Exception e) {
            log.debugf(e, "Cannot log tree graph", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource<L>> removeResources(L query, LocationResolver<L> locationResolver) {
        this.graphLockWrite.lock();
        try {
            ArrayList<Resource<L>> doomedResources = new ArrayList<Resource<L>>();
            DepthFirstIterator it = new DepthFirstIterator(this.resourcesGraph);
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                if (!locationResolver.matches(query, resource.getLocation())) continue;
                this.getAllDescendants(resource, doomedResources);
                doomedResources.add(resource);
            }
            for (Resource resource : doomedResources) {
                this.resourcesGraph.removeVertex((Object)resource);
            }
            List list = Collections.unmodifiableList(doomedResources);
            return list;
        }
        finally {
            this.graphLockWrite.unlock();
        }
    }

    private void reinitializeIfNecessary() {
        if (this.resourceCache == null || this.resourceCache.size() > 0) {
            this.resourcesGraph = new ListenableDirectedGraph(DefaultEdge.class);
            this.neighborIndex = new DirectedNeighborIndex(this.resourcesGraph);
            this.resourcesGraph.addGraphListener(this.neighborIndex);
            this.resourceCache = new HashMap<ID, Resource<L>>();
            this.resourcesGraph.addVertexSetListener((VertexSetListener)new VertexCacheListener());
        }
    }

    private void getAllDescendants(Resource<L> parent, List<Resource<L>> descendants) {
        for (Resource<L> child : this.getChildren(parent)) {
            if (descendants.contains(child)) continue;
            this.getAllDescendants(child, descendants);
            descendants.add(child);
        }
    }

    private class ResourceComparator
    implements Comparator<Resource<L>> {
        private ResourceComparator() {
        }

        @Override
        public int compare(Resource<L> r1, Resource<L> r2) {
            int c = r1.getID().compareTo(r2.getID());
            if (c != 0) {
                return c;
            }
            c = r1.getName().compareTo(r2.getName());
            if (c != 0) {
                return c;
            }
            Collection rcp1 = r1.getResourceConfigurationProperties();
            Collection rcp2 = r2.getResourceConfigurationProperties();
            if (rcp1.size() == rcp2.size()) {
                if (!rcp1.isEmpty()) {
                    HashMap rcp1Map = new HashMap(rcp1.size());
                    for (ResourceConfigurationPropertyInstance rcp1Item : rcp1) {
                        rcp1Map.put(rcp1Item, rcp1Item.getValue());
                    }
                    HashMap rcp2Map = new HashMap(rcp2.size());
                    for (ResourceConfigurationPropertyInstance rcp2Item : rcp2) {
                        rcp2Map.put(rcp2Item, rcp2Item.getValue());
                    }
                    if (!rcp1Map.equals(rcp2Map)) {
                        return rcp1Map.hashCode() < rcp2Map.hashCode() ? -1 : 1;
                    }
                }
            } else {
                return rcp1.size() < rcp2.size() ? -1 : 1;
            }
            if (!r1.getProperties().equals(r2.getProperties())) {
                return r1.getProperties().hashCode() < r2.getProperties().hashCode() ? -1 : 1;
            }
            return 0;
        }
    }

    private class VertexCacheListener
    implements VertexSetListener<Resource<L>> {
        private VertexCacheListener() {
        }

        public void vertexAdded(GraphVertexChangeEvent<Resource<L>> e) {
            ResourceManager.this.resourceCache.put(((Resource)e.getVertex()).getID(), e.getVertex());
        }

        public void vertexRemoved(GraphVertexChangeEvent<Resource<L>> e) {
            ResourceManager.this.resourceCache.remove(((Resource)e.getVertex()).getID());
        }
    }

    public static class AddResult<L> {
        private final Resource<L> resource;
        private final Effect effect;

        public AddResult(Effect effect, Resource<L> resource) {
            this.resource = resource;
            this.effect = effect;
        }

        public Effect getEffect() {
            return this.effect;
        }

        public Resource<L> getResource() {
            return this.resource;
        }

        public static enum Effect {
            ADDED,
            MODIFIED,
            UNCHANGED;

        }
    }
}

