/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.enterprise.concurrent.LastExecution;
import javax.enterprise.concurrent.Trigger;
import org.glassfish.enterprise.concurrent.AbstractManagedExecutorService;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.ControlPointUtils;
import org.wildfly.extension.requestcontroller.ControlPoint;

public class ManagedScheduledExecutorServiceImpl
extends org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl {
    private final ControlPoint controlPoint;

    public ManagedScheduledExecutorServiceImpl(String name, ManagedThreadFactoryImpl managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, ContextServiceImpl contextService, AbstractManagedExecutorService.RejectPolicy rejectPolicy, ControlPoint controlPoint) {
        super(name, managedThreadFactory, hungTaskThreshold, longRunningTasks, corePoolSize, keepAliveTime, keepAliveTimeUnit, threadLifeTime, contextService, rejectPolicy);
        this.controlPoint = controlPoint;
    }

    public void execute(Runnable command) {
        super.execute(ControlPointUtils.doWrap(command, this.controlPoint));
    }

    public Future<?> submit(Runnable task) {
        return super.submit(ControlPointUtils.doWrap(task, this.controlPoint));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(ControlPointUtils.doWrap(task, this.controlPoint), result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(ControlPointUtils.doWrap(task, this.controlPoint));
    }

    public ScheduledFuture<?> schedule(Runnable command, Trigger trigger) {
        CancellableTrigger ctrigger = new CancellableTrigger(trigger);
        ctrigger.future = super.schedule(ControlPointUtils.doScheduledWrap(command, this.controlPoint), (Trigger)ctrigger);
        return ctrigger.future;
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, Trigger trigger) {
        CancellableTrigger ctrigger = new CancellableTrigger(trigger);
        ctrigger.future = super.schedule(ControlPointUtils.doScheduledWrap(callable, this.controlPoint), (Trigger)ctrigger);
        return ctrigger.future;
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(ControlPointUtils.doScheduledWrap(command, this.controlPoint), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return super.schedule(ControlPointUtils.doScheduledWrap(callable, this.controlPoint), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(ControlPointUtils.doScheduledWrap(command, this.controlPoint), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(ControlPointUtils.doScheduledWrap(command, this.controlPoint), initialDelay, delay, unit);
    }

    private static class CancellableTrigger
    implements Trigger {
        private final Trigger trigger;
        private ScheduledFuture future;

        CancellableTrigger(Trigger trigger) {
            this.trigger = trigger;
        }

        public Date getNextRunTime(LastExecution lastExecution, Date taskScheduledTime) {
            Date nextRunTime = this.trigger.getNextRunTime(lastExecution, taskScheduledTime);
            ScheduledFuture future = this.future;
            if (future != null && future.isCancelled()) {
                nextRunTime = null;
            }
            return nextRunTime;
        }

        public boolean skipRun(LastExecution lastExecution, Date date) {
            return this.trigger.skipRun(lastExecution, date);
        }
    }
}

