/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;

public abstract class Filter {
    private static final Filter[] EMPTY = new Filter[0];

    public static Accumulator by(Filter ... filters) {
        return new Accumulator(filters);
    }

    public static Filter[] all() {
        return EMPTY;
    }

    public static Filter[] pathTo(Entity<?, ?> entity) {
        return Filter.pathTo(entity.getPath());
    }

    public static Filter[] pathTo(CanonicalPath path) {
        if (!path.isDefined()) {
            return new Filter[0];
        }
        ArrayList<Filter> fs = new ArrayList<Filter>();
        for (Path.Segment s : path.getPath()) {
            fs.add(Related.by(Relationships.WellKnown.contains));
            fs.add(With.type(Entity.entityTypeFromSegmentType(s.getElementType())));
            fs.add(With.id(s.getElementId()));
        }
        if (fs.size() < 2) {
            return new Filter[0];
        }
        List ret = fs.subList(1, fs.size());
        return ret.toArray(new Filter[ret.size()]);
    }

    public static final class Accumulator {
        private final List<Filter> filters = new ArrayList<Filter>();

        private Accumulator(Filter ... fs) {
            for (Filter filter : fs) {
                this.filters.add(filter);
            }
        }

        public Accumulator and(Filter f) {
            this.filters.add(f);
            return this;
        }

        public Accumulator and(Filter ... fs) {
            Collections.addAll(this.filters, fs);
            return this;
        }

        public Filter[] get() {
            return this.filters.toArray(new Filter[this.filters.size()]);
        }
    }
}

