/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import io.swagger.annotations.ApiModel;
import java.util.Map;
import java.util.Set;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.SyncedEntity;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;

@ApiModel(description="A feed represents a remote \"agent\" that is reporting its data to Hawkular.", parent=SyncedEntity.class)
public final class Feed
extends SyncedEntity<Blueprint, Update> {
    public static final SegmentType SEGMENT_TYPE = SegmentType.f;

    private Feed() {
    }

    public Feed(CanonicalPath path, String identityHash, String contentHash, String syncHash) {
        this(path, identityHash, contentHash, syncHash, null);
    }

    public Feed(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash) {
        super(name, path, identityHash, contentHash, syncHash);
    }

    public Feed(CanonicalPath path, String identityHash, String contentHash, String syncHash, Map<String, Object> properties) {
        super(path, identityHash, contentHash, syncHash, properties);
    }

    public Feed(String name, CanonicalPath path, String identityHash, String contentHash, String syncHash, Map<String, Object> properties) {
        super(name, path, identityHash, contentHash, syncHash, properties);
    }

    @Override
    public AbstractElement.Updater<Update, Feed> update() {
        return new AbstractElement.Updater<Update, Feed>(u -> new Feed(u.getName(), this.getPath(), this.getIdentityHash(), this.getContentHash(), this.getSyncHash(), u.getProperties()));
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitFeed(this, parameter);
    }

    @ApiModel(value="FeedUpdate")
    public static final class Update
    extends Entity.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(null, properties);
        }

        public Update(String name, Map<String, Object> properties) {
            super(name, properties);
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitFeed(this, parameter);
        }

        public static final class Builder
        extends Entity.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.name, this.properties);
            }
        }
    }

    @ApiModel(value="FeedBlueprint")
    public static final class Blueprint
    extends Entity.Blueprint {
        private static final String AUTO_ID_FLAG = "__auto-generate-id";

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
        }

        public Blueprint(String id, Map<String, Object> properties) {
            super(id == null ? AUTO_ID_FLAG : id, properties);
        }

        public Blueprint(String id, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, properties, outgoing, incoming);
        }

        public Blueprint(String id, String name, Map<String, Object> properties) {
            super(id, name, properties);
        }

        public Blueprint(String id, String name, Map<String, Object> properties, Map<String, Set<CanonicalPath>> outgoing, Map<String, Set<CanonicalPath>> incoming) {
            super(id, name, properties, outgoing, incoming);
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitFeed(this, parameter);
        }

        public static boolean shouldAutogenerateId(Feed proposedFeed) {
            return AUTO_ID_FLAG.equals(proposedFeed.getId());
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.name, this.properties, this.outgoing, this.incoming);
            }
        }
    }
}

