/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.NoTransportBuilder;
import org.jboss.as.clustering.infinispan.subsystem.SiteBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.GroupAliasBuilderProvider;

public class NoTransportServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddress().getParent().getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        new NoTransportBuilder(name).build(target).install();
        new SiteBuilder(name).build(target).install();
        for (GroupAliasBuilderProvider provider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
            for (Builder builder : provider.getBuilders(name, "local")) {
                builder.build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) {
        String name = context.getCurrentAddress().getParent().getLastElement().getValue();
        for (GroupAliasBuilderProvider provider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
            for (Builder builder : provider.getBuilders(name, "local")) {
                context.removeService(builder.getServiceName());
            }
        }
        for (CacheContainerComponent factory : CacheContainerComponent.values()) {
            context.removeService(factory.getServiceName(name));
        }
    }
}

