/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.SiteConfiguration;
import org.infinispan.configuration.global.SiteConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.JGroupsTransportResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.service.Builder;

public class SiteBuilder
extends CacheContainerComponentBuilder<SiteConfiguration>
implements ResourceServiceBuilder<SiteConfiguration> {
    private final InjectedValue<ChannelFactory> factory = new InjectedValue();
    private volatile String channelName = null;

    public SiteBuilder(String containerName) {
        super(CacheContainerComponent.SITE, containerName);
    }

    @Override
    public ServiceBuilder<SiteConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        if (this.channelName != null) {
            builder.addDependency(ChannelServiceName.FACTORY.getServiceName(this.channelName), ChannelFactory.class, this.factory);
        }
        return builder;
    }

    public Builder<SiteConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.channelName = ModelNodes.asString((ModelNode)JGroupsTransportResourceDefinition.Attribute.CHANNEL.getDefinition().resolveModelAttribute(context, model), (String)"default");
        return this;
    }

    public SiteConfiguration getValue() {
        RelayConfiguration relay;
        SiteConfigurationBuilder builder = new GlobalConfigurationBuilder().site();
        ChannelFactory factory = (ChannelFactory)this.factory.getOptionalValue();
        if (factory != null && (relay = ((ChannelFactory)this.factory.getValue()).getProtocolStackConfiguration().getRelay()) != null) {
            builder.localSite(relay.getSiteName());
        }
        return builder.create();
    }
}

