/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addons.transports.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.spi.http.HttpExchange;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jaxws_spi.HttpHandlerImpl;
import org.apache.cxf.transport.http_jaxws_spi.JAXWSHttpSpiDestination;
import org.jboss.ws.undertow_httpspi.UndertowHttpExchange;
import org.jboss.wsf.stack.cxf.addons.transports.undertow.SecurityActions;
import org.jboss.wsf.stack.cxf.addons.transports.undertow.UndertowServerEngine;
import org.jboss.wsf.stack.cxf.addons.transports.undertow.UndertowServerEngineFactory;

public class UndertowServerDestination
extends JAXWSHttpSpiDestination {
    static final Logger LOG = LogUtils.getL7dLogger(UndertowServerDestination.class);
    private UndertowServerEngineFactory serverEngineFactory = this.getServerEngineFactory();
    private UndertowServerEngine engine;
    private URL url;

    public UndertowServerDestination(Bus b, DestinationRegistry registry, EndpointInfo ei) throws IOException {
        super(b, registry, ei);
        UndertowServerDestination.getAddressValue((EndpointInfo)ei, (boolean)true);
        this.url = new URL(ei.getAddress());
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void finalizeConfig() {
        this.engine = this.serverEngineFactory.retrieveHttpServerEngine(this.url.getPort());
        if (this.engine == null) {
            try {
                this.engine = this.serverEngineFactory.createHttpServerEngine(this.url.getHost(), this.url.getPort(), this.url.getProtocol());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.url.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.url + "\"");
        }
    }

    protected UndertowServerEngineFactory getServerEngineFactory() {
        UndertowServerEngineFactory serverEngineFactory = (UndertowServerEngineFactory)this.getBus().getExtension(UndertowServerEngineFactory.class);
        if (serverEngineFactory == null) {
            serverEngineFactory = new UndertowServerEngineFactory(this.bus);
        }
        return serverEngineFactory;
    }

    protected void activate() {
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        String addr = this.endpointInfo.getAddress();
        try {
            new URL(addr);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        this.engine.addHandler(addr, new Handler(this, SecurityActions.getContextClassLoader()));
    }

    protected void deactivate() {
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeHandler(this.endpointInfo.getAddress());
    }

    class Handler
    extends HttpHandlerImpl
    implements HttpHandler {
        private ClassLoader classLoader;

        public Handler(JAXWSHttpSpiDestination destination, ClassLoader classLoader) {
            super(destination);
            this.classLoader = classLoader;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(this.classLoader);
                this.handle((HttpExchange)new UndertowHttpExchange(exchange));
            }
            catch (Exception e) {
                LOG.throwing(Handler.class.getName(), "handle(" + HttpServerExchange.class.getName() + " ex)", e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }
}

