/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.InventoryStructure;

public class InventoryStructureDeserializer
extends JsonDeserializer<InventoryStructure.Offline<?>> {
    public static final String LEGAL_ENTITY_TYPES = Stream.of(InventoryStructure.EntityType.values()).map(Enum::name).collect(Collectors.joining("', '", "'", "'"));

    public InventoryStructure.Offline<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        InventoryStructure.EntityType type;
        JsonNode tree = (JsonNode)jsonParser.readValueAsTree();
        if (tree == null) {
            throw new JsonParseException("Inventory structure expected but got nothing.", jsonParser.getCurrentLocation());
        }
        JsonToken token = tree.asToken();
        if (token != JsonToken.START_OBJECT) {
            throw new JsonParseException("Expected object but got " + token.asString(), JsonLocation.NA);
        }
        JsonNode typeNode = tree.get("type");
        if (!typeNode.isTextual()) {
            throw new JsonParseException("'type' must be a text", JsonLocation.NA);
        }
        String typeName = typeNode.textValue();
        try {
            type = InventoryStructure.EntityType.valueOf((String)typeName);
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Unrecognized value of 'type'. Supported values are " + LEGAL_ENTITY_TYPES + " but got '" + typeName + "'.", JsonLocation.NA);
        }
        Entity.Blueprint root = (Entity.Blueprint)deserializationContext.readValue(InventoryStructureDeserializer.prepareTraverse(tree.get("data"), deserializationContext), type.blueprintType);
        InventoryStructure.Builder bld = InventoryStructure.Offline.of((Entity.Blueprint)root);
        this.parseChildren(tree, (InventoryStructure.AbstractBuilder<?>)bld, deserializationContext);
        return bld.build();
    }

    private void parseChildren(JsonNode root, InventoryStructure.AbstractBuilder<?> bld, DeserializationContext mapper) throws IOException {
        JsonNode children = root.get("children");
        if (children == null) {
            return;
        }
        if (!children.isObject()) {
            throw new JsonParseException("The 'children' is supposed to be an object.", JsonLocation.NA);
        }
        Iterator fields = children.fields();
        while (fields.hasNext()) {
            InventoryStructure.EntityType type;
            Map.Entry e = (Map.Entry)fields.next();
            String typeName = (String)e.getKey();
            JsonNode childrenNode = (JsonNode)e.getValue();
            if (!childrenNode.isArray()) continue;
            try {
                type = InventoryStructure.EntityType.valueOf((String)typeName);
            }
            catch (IllegalArgumentException ex) {
                throw new JsonParseException("Unrecognized value of 'type'. Supported values are " + LEGAL_ENTITY_TYPES + " but got '" + typeName + "'.", JsonLocation.NA);
            }
            Iterator childrenNodes = childrenNode.elements();
            while (childrenNodes.hasNext()) {
                JsonNode childNode = (JsonNode)childrenNodes.next();
                Entity.Blueprint bl = (Entity.Blueprint)mapper.readValue(InventoryStructureDeserializer.prepareTraverse(childNode.get("data"), mapper), type.blueprintType);
                InventoryStructure.ChildBuilder childBld = bld.startChild(bl);
                this.parseChildren(childNode, (InventoryStructure.AbstractBuilder<?>)childBld, mapper);
                childBld.end();
            }
        }
    }

    private static JsonParser prepareTraverse(JsonNode node, DeserializationContext ctx) throws IOException {
        JsonParser parser = node.traverse(ctx.getParser().getCodec());
        parser.nextToken();
        return parser;
    }
}

