/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jca;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.accesscontrol.HostServerOperationAccess;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class JDBCDriverInfoHandler
extends BaseOperationCommand {
    private final ArgumentWithValue host;
    private final ArgumentWithValue server;
    private final ArgumentWithValue name;
    private HostServerOperationAccess hostServerPermission;

    public JDBCDriverInfoHandler(CommandContext ctx) {
        super(ctx, "jdbc-driver-info", true);
        this.addRequiredPath("/subsystem=datasources");
        this.host = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                return JDBCDriverInfoHandler.this.hostServerPermission.getAllowedHosts(ctx);
            }
        }), "--host"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                return ctx.isDomainMode() && super.canAppearNext(ctx);
            }
        };
        final HostServerOperationAccess hostServerPermission = this.hostServerPermission;
        this.server = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                return hostServerPermission.getAllowedServers(ctx, JDBCDriverInfoHandler.this.host.getValue(ctx.getParsedCommandLine()));
            }
        }), "--server"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                return JDBCDriverInfoHandler.this.host.isPresent(ctx.getParsedCommandLine()) && super.canAppearNext(ctx);
            }
        };
        this.name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                try {
                    ModelNode req = JDBCDriverInfoHandler.this.buildRequestWithoutHeaders(ctx);
                    ModelNode response = ctx.getModelControllerClient().execute(req);
                    if (response.hasDefined("result")) {
                        List<ModelNode> list = response.get("result").asList();
                        ArrayList<String> names = new ArrayList<String>(list.size());
                        for (ModelNode node : list) {
                            if (!node.hasDefined("driver-name")) continue;
                            names.add(node.get("driver-name").asString());
                        }
                        return names;
                    }
                    return Collections.emptyList();
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }
        }), 0, "--name"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode()) {
                    return JDBCDriverInfoHandler.this.host.isPresent(ctx.getParsedCommandLine()) && JDBCDriverInfoHandler.this.server.isPresent(ctx.getParsedCommandLine()) && super.canAppearNext(ctx);
                }
                return super.canAppearNext(ctx);
            }
        };
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.hostServerPermission = new HostServerOperationAccess(ctx, "subsystem=datasources", "installed-drivers-list");
        return AccessRequirementBuilder.Factory.create(ctx).any().operation("subsystem=datasources", "installed-drivers-list").requirement(this.hostServerPermission).build();
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ModelNode req = new ModelNode();
        ModelNode address = req.get("address");
        if (ctx.isDomainMode()) {
            address.add("host", this.host.getValue(ctx.getParsedCommandLine(), true));
            address.add("server", this.server.getValue(ctx.getParsedCommandLine(), true));
        }
        address.add("subsystem", "datasources");
        req.get("operation").set("installed-drivers-list");
        return req;
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandLineException {
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            throw new CommandLineException("The operation result is not defined: " + result);
        }
        List<ModelNode> list = result.asList();
        if (!this.name.isPresent(ctx.getParsedCommandLine())) {
            SimpleTable table = new SimpleTable(new String[]{"NAME", "SOURCE"});
            for (ModelNode node : list) {
                String source;
                ModelNode driverName = node.get("driver-name");
                if (!driverName.isDefined()) {
                    throw new CommandLineException("driver-name is not available: " + node);
                }
                if (node.hasDefined("deployment-name")) {
                    source = node.get("deployment-name").asString();
                } else if (node.hasDefined("driver-module-name")) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(node.get("driver-module-name").asString());
                    if (node.hasDefined("module-slot")) {
                        buf.append('/').append(node.get("module-slot").asString());
                    }
                    source = buf.toString();
                } else {
                    source = "n/a";
                }
                table.addLine(driverName.asString(), source);
            }
            ctx.printLine(table.toString(true));
        } else {
            String name = this.name.getValue(ctx.getParsedCommandLine());
            SimpleTable table = new SimpleTable(2);
            for (ModelNode node : list) {
                ModelNode driverName = node.get("driver-name");
                if (!driverName.isDefined()) {
                    throw new CommandLineException("driver-name is not available: " + node);
                }
                if (!name.equals(driverName.asString())) continue;
                for (String propName : node.keys()) {
                    ModelNode value = node.get(propName);
                    table.addLine(propName, value.isDefined() ? value.asString() : "n/a");
                }
            }
            ctx.printLine(table.toString(false));
        }
    }
}

