/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.deployment;

import org.jboss.as.security.service.JaccService;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;

public abstract class AbstractSecurityDeployer<T> {
    public JaccService<T> deploy(DeploymentUnit deploymentUnit) {
        String contextId = deploymentUnit.getName();
        if (deploymentUnit.getParent() != null) {
            contextId = deploymentUnit.getParent().getName() + "!" + contextId;
        }
        return this.deploy(deploymentUnit, contextId);
    }

    public JaccService<T> deploy(DeploymentUnit deploymentUnit, String jaccContextId) {
        Object metaData = deploymentUnit.getAttachment(this.getMetaDataType());
        Boolean standalone = Boolean.FALSE;
        if (deploymentUnit.getParent() == null) {
            standalone = Boolean.TRUE;
        }
        return this.createService(jaccContextId, metaData, standalone);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    protected abstract JaccService<T> createService(String var1, T var2, Boolean var3);

    protected abstract AttachmentKey<T> getMetaDataType();
}

