/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AbstractClassificationResource;
import org.jboss.as.domain.management.access.ApplicationClassificationConfigResourceDefinition;

public class ApplicationClassificationTypeResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"type");
    static ApplicationClassificationTypeResourceDefinition INSTANCE = new ApplicationClassificationTypeResourceDefinition();

    private ApplicationClassificationTypeResourceDefinition() {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.application-classification-type"));
    }

    static Resource.ResourceEntry createResource(Map<String, ApplicationTypeConfig> classificationsByType, String name, AccessConstraintUtilizationRegistry registry) {
        return new ApplicationTypeResource(PathElement.pathElement((String)"type", (String)name), classificationsByType, registry);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new ApplicationClassificationConfigResourceDefinition());
    }

    private static class ApplicationTypeResource
    extends AbstractClassificationResource {
        private static final Set<String> CHILD_TYPES = Collections.singleton("classification");
        private final Map<String, ApplicationTypeConfig> applicationClassificationsByName;
        private final AccessConstraintUtilizationRegistry registry;

        ApplicationTypeResource(PathElement pathElement, Map<String, ApplicationTypeConfig> classificationsByType, AccessConstraintUtilizationRegistry registry) {
            super(pathElement);
            this.applicationClassificationsByName = classificationsByType;
            this.registry = registry;
        }

        public Set<String> getChildTypes() {
            return CHILD_TYPES;
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            ApplicationTypeConfig classification;
            if (type.equals("classification") && (classification = this.applicationClassificationsByName.get(name)) != null) {
                String classificationType = this.getPathElement().getValue();
                return ApplicationClassificationConfigResourceDefinition.createResource(classification, classificationType, name, this.registry);
            }
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            if (type.equals("classification")) {
                return this.applicationClassificationsByName.keySet();
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            if (childType.equals("classification")) {
                HashSet<Resource.ResourceEntry> entries = new HashSet<Resource.ResourceEntry>();
                for (Map.Entry<String, ApplicationTypeConfig> entry : this.applicationClassificationsByName.entrySet()) {
                    entries.add(ApplicationClassificationConfigResourceDefinition.createResource(entry.getValue(), childType, entry.getKey(), this.registry));
                }
                return entries;
            }
            return Collections.emptySet();
        }
    }
}

